/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.lite.edit.parts.decorations;

import java.util.HashMap;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gmf.runtime.lite.edit.parts.decorations.IDecorationManager;

public abstract class AbstractDecorationManager
implements IDecorationManager {
    private final IFigure myDecorationParent;
    private HashMap<String, IFigure> myDecorations;

    public AbstractDecorationManager(IFigure decorationParent) {
        this.myDecorationParent = decorationParent;
    }

    public void installDecoration(String key, IFigure decoration) {
        IFigure currentDecoration = this.getDecoration(key);
        if (currentDecoration != null) {
            this.myDecorations.remove(key);
            this.myDecorationParent.remove(currentDecoration);
        }
        if (decoration != null) {
            this.putDecoration(key, decoration);
            this.myDecorationParent.add(decoration, this.getConstraint(key, decoration));
        }
    }

    public IFigure getDecoration(String key) {
        return this.myDecorations == null ? null : this.myDecorations.get(key);
    }

    private void putDecoration(String key, IFigure decoration) {
        if (this.myDecorations == null) {
            this.myDecorations = new HashMap();
        }
        this.myDecorations.put(key, decoration);
    }

    protected IFigure getDecorationParent() {
        return this.myDecorationParent;
    }

    protected abstract Object getConstraint(String var1, IFigure var2);
}

