/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.draw2d.ui.figures;

import org.eclipse.draw2d.AbstractConnectionAnchor;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gmf.runtime.draw2d.ui.figures.IPolygonAnchorableFigure;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.LineSeg;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.PointListUtilities;

public class BaseSlidableAnchor
extends AbstractConnectionAnchor {
    private static final char TERMINAL_START_CHAR = '(';
    private static final char TERMINAL_DELIMITER_CHAR = ',';
    private static final char TERMINAL_END_CHAR = ')';
    private PrecisionPoint relativeReference;
    private static int STRAIGHT_LINE_TOLERANCE = 10;

    public BaseSlidableAnchor() {
    }

    public BaseSlidableAnchor(IFigure f) {
        super(f);
    }

    public BaseSlidableAnchor(IFigure f, PrecisionPoint p) {
        super(f);
        this.relativeReference = new PrecisionPoint(p.preciseX, p.preciseY);
    }

    public String getTerminal() {
        if (this.isDefaultAnchor()) {
            return "";
        }
        return this.composeTerminalString(this.relativeReference);
    }

    public Point getReferencePoint() {
        return this.getAnchorPosition();
    }

    private String composeTerminalString(PrecisionPoint p) {
        StringBuffer s = new StringBuffer(24);
        s.append('(');
        s.append((float)p.preciseX);
        s.append(',');
        s.append((float)p.preciseY);
        s.append(')');
        return s.toString();
    }

    private Point getAnchorPosition() {
        Rectangle rBox = this.getBox();
        if (this.isDefaultAnchor()) {
            return rBox.getCenter();
        }
        return new Point((double)Math.round(this.relativeReference.preciseX * (double)rBox.width + (double)rBox.x), (double)Math.round(this.relativeReference.preciseY * (double)rBox.height + (double)rBox.y));
    }

    protected Point getLocation(Point ownReference, Point foreignReference) {
        PointList intersections = this.getIntersectionPoints(ownReference, foreignReference);
        if (intersections != null && intersections.size() != 0) {
            Point location = PointListUtilities.pickClosestPoint(intersections, foreignReference);
            return location;
        }
        return null;
    }

    public Point getLocation(Point reference) {
        Point foreignReference = reference.getCopy();
        Point ownReference = this.getReferencePoint().getCopy();
        Point location = this.getLocation(ownReference = this.normalizeToStraightlineTolerance(foreignReference, ownReference, STRAIGHT_LINE_TOLERANCE), foreignReference);
        if (location == null || this.getBox().expand(1, 1).contains(foreignReference) && !this.getBox().shrink(1, 1).contains(foreignReference)) {
            location = this.getLocation(this.getBox().getCenter(), foreignReference);
        }
        if (location == null) {
            location = this.getBox().getCenter();
        }
        return location;
    }

    protected Point normalizeToStraightlineTolerance(Point foreignReference, Point ownReference, int tolerance) {
        Point normalizedReference = ownReference.getCopy();
        if (Math.abs(foreignReference.x - ownReference.x) < tolerance || Math.abs(foreignReference.y - ownReference.y) < tolerance) {
            LineSeg lineSeg = new LineSeg(ownReference, foreignReference);
            normalizedReference = lineSeg.perpIntersect(ownReference.x, ownReference.y);
            if (Math.abs(normalizedReference.x - foreignReference.x) < Math.abs(normalizedReference.y - foreignReference.y)) {
                normalizedReference.x = foreignReference.x;
            } else {
                normalizedReference.y = foreignReference.y;
            }
        }
        return normalizedReference;
    }

    protected PointList getIntersectionPoints(Point ownReference, Point foreignReference) {
        PointList polygon = this.getPolygonPoints();
        return new LineSeg(ownReference, foreignReference).getLineIntersectionsWithLineSegs(polygon);
    }

    protected PointList getPolygonPoints() {
        if (this.getOwner() instanceof IPolygonAnchorableFigure) {
            PointList polyList = ((IPolygonAnchorableFigure)this.getOwner()).getPolygonPoints();
            this.getOwner().translateToAbsolute((Translatable)polyList);
            return polyList;
        }
        Rectangle rBox = this.getBox();
        PointList ptList = new PointList();
        ptList.addPoint(rBox.getTopLeft());
        ptList.addPoint(rBox.getTopRight());
        ptList.addPoint(rBox.getBottomRight());
        ptList.addPoint(rBox.getBottomLeft());
        ptList.addPoint(rBox.getTopLeft());
        return ptList;
    }

    public static PrecisionPoint getAnchorRelativeLocation(Point p, Rectangle bounds) {
        PrecisionPoint relLocation;
        Point temp = new Point(p);
        if (p.x < bounds.x || p.x > bounds.x + bounds.width || p.y < bounds.y || p.y > bounds.y + bounds.height) {
            if (p.x < bounds.x || p.x > bounds.x + bounds.width) {
                int n = temp.x = p.x < bounds.x ? bounds.x : bounds.x + bounds.width;
            }
            if (p.y < bounds.y || p.y > bounds.y + bounds.height) {
                temp.y = p.y < bounds.y ? bounds.y : bounds.y + bounds.height;
            }
            relLocation = new PrecisionPoint((double)(temp.x - bounds.x) / (double)bounds.width, (double)(temp.y - bounds.y) / (double)bounds.height);
        } else {
            relLocation = new PrecisionPoint((double)(temp.x - bounds.x) / (double)bounds.width, (double)(temp.y - bounds.y) / (double)bounds.height);
        }
        return relLocation;
    }

    protected Rectangle getBox() {
        Rectangle rBox = this.getOwner() instanceof Connection ? ((Connection)this.getOwner()).getPoints().getBounds().getCopy() : this.getOwner().getBounds().getCopy();
        PrecisionRectangle box = new PrecisionRectangle(rBox);
        this.getOwner().translateToAbsolute((Translatable)box);
        return box;
    }

    public boolean isDefaultAnchor() {
        return this.relativeReference == null;
    }

    public static PrecisionPoint parseTerminalString(String terminal) {
        try {
            return new PrecisionPoint((double)Float.parseFloat(terminal.substring(terminal.indexOf(40) + 1, terminal.indexOf(44))), (double)Float.parseFloat(terminal.substring(terminal.indexOf(44) + 1, terminal.indexOf(41))));
        }
        catch (Exception exception) {
            return null;
        }
    }
}

