/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.internal.ruler;

import java.util.ArrayList;
import org.eclipse.draw2d.PositionConstants;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.SnapToHelper;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.editparts.ISurfaceEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.ruler.CompoundSnapToHelperEx;
import org.eclipse.gmf.runtime.diagram.ui.internal.ruler.SnapToGeometryEx;
import org.eclipse.gmf.runtime.diagram.ui.internal.ruler.SnapToGridEx;
import org.eclipse.gmf.runtime.diagram.ui.internal.ruler.SnapToGuidesEx;

public class SnapToHelperUtil
implements PositionConstants {
    public static final String RESTRICTED_DIRECTIONS = "org.eclipse.gmf.runtime.diagram.ui.RestrictedDirections";

    public static Object getSnapHelper(GraphicalEditPart editPart) {
        GraphicalEditPart diagramEditPart = editPart;
        while (diagramEditPart != null && !(diagramEditPart instanceof DiagramEditPart)) {
            diagramEditPart = (GraphicalEditPart)diagramEditPart.getParent();
        }
        if (diagramEditPart == null) {
            return null;
        }
        GraphicalEditPart parent = editPart;
        while (parent != null && !(parent instanceof ISurfaceEditPart)) {
            parent = (GraphicalEditPart)parent.getParent();
        }
        if (parent == null) {
            parent = diagramEditPart;
        }
        ArrayList<Object> snapStrategies = new ArrayList<Object>();
        EditPartViewer viewer = diagramEditPart.getViewer();
        Boolean val = (Boolean)editPart.getViewer().getProperty("ruler$visibility");
        if (val != null && val.booleanValue()) {
            snapStrategies.add((Object)new SnapToGuidesEx(diagramEditPart));
        }
        if ((val = (Boolean)viewer.getProperty("SnapToGeometry.isEnabled")) != null && val.booleanValue()) {
            snapStrategies.add((Object)new SnapToGeometryEx(parent));
        }
        if ((val = (Boolean)viewer.getProperty("SnapToGrid.isEnabled")) != null && val.booleanValue()) {
            snapStrategies.add((Object)new SnapToGridEx(diagramEditPart));
        }
        if (snapStrategies.size() == 0) {
            return null;
        }
        if (snapStrategies.size() == 1) {
            return snapStrategies.get(0);
        }
        SnapToHelper[] ss = new SnapToHelper[snapStrategies.size()];
        int i = 0;
        while (i < snapStrategies.size()) {
            ss[i] = (SnapToHelper)snapStrategies.get(i);
            ++i;
        }
        return new CompoundSnapToHelperEx(ss);
    }

    public static int updateSnapLocations(int snapLocations, int restrictedDirections) {
        if (restrictedDirections == 0) {
            return snapLocations;
        }
        if ((snapLocations & 0x40) != 0 && (restrictedDirections & 0x10) == 0 && (restrictedDirections & 8) == 0) {
            snapLocations &= 0xFFFFFFBF;
        }
        if ((snapLocations & 0x80) != 0 && (restrictedDirections & 4) == 0 && (restrictedDirections & 1) == 0) {
            snapLocations &= 0xFFFFFF7F;
        }
        return snapLocations;
    }
}

