/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.resources.editor.document;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.AbstractDocumentProvider;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.DiagramDocument;
import org.eclipse.gmf.runtime.notation.Diagram;

public class DiagramModificationListener
extends EContentAdapter {
    private TransactionalEditingDomain editingDomain;
    private NotificationFilter diagramResourceModifiedFilter;
    private DiagramDocument document;

    public DiagramModificationListener(AbstractDocumentProvider documentProvider, DiagramDocument document) {
        this.document = document;
        Diagram diagram = document.getDiagram();
        this.editingDomain = TransactionUtil.getEditingDomain((EObject)diagram);
        this.diagramResourceModifiedFilter = NotificationFilter.createNotifierFilter((Object)diagram.eResource()).and(NotificationFilter.createEventTypeFilter((int)1).or(NotificationFilter.createEventTypeFilter((int)2))).and(NotificationFilter.createFeatureFilter(Resource.class, (int)3));
    }

    public void startListening() {
        EList adapters = this.getEditingDomain().getResourceSet().eAdapters();
        if (!adapters.contains((Object)this)) {
            adapters.add((Object)this);
        }
    }

    public void stopListening() {
        this.getEditingDomain().getResourceSet().eAdapters().remove((Object)this);
    }

    protected TransactionalEditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    protected DiagramDocument getDiagramDocument() {
        return this.document;
    }

    public boolean isAdapterForType(Object type) {
        return type == DiagramModificationListener.class;
    }

    public void notifyChanged(Notification notification) {
        Resource notifierResource;
        EList contents;
        if (notification.getNotifier() instanceof ResourceSet) {
            super.notifyChanged(notification);
        }
        if (this.diagramResourceModifiedFilter.matches(notification) && this.getDiagramDocument().getDiagram() != null && notification.getNotifier() instanceof Resource && !(contents = (notifierResource = (Resource)notification.getNotifier()).getContents()).isEmpty()) {
            Object root = contents.get(0);
            if (notification.getNewBooleanValue() && !notification.getOldBooleanValue() && root instanceof EObject && ((EObject)root).eResource() != null && ((EObject)root).eResource().equals(notifierResource) && notifierResource.isLoaded()) {
                this.getDiagramDocument().setContent(this.getDiagramDocument().getContent());
            }
        }
    }

    public void unsetTarget(Notifier oldTarget) {
        if (oldTarget instanceof ResourceSet) {
            super.unsetTarget(oldTarget);
        }
    }

    public Notifier getTarget() {
        return null;
    }

    public void setTarget(Notifier newTarget) {
        if (newTarget instanceof ResourceSet) {
            super.setTarget(newTarget);
        }
    }
}

