/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.graphdef.editor.edit.parts;

import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.gmf.graphdef.editor.edit.parts.CanvasEditPart;
import org.eclipse.gmf.graphdef.editor.edit.parts.CompartmentEditPart;
import org.eclipse.gmf.graphdef.editor.edit.parts.CompartmentNameEditPart;
import org.eclipse.gmf.graphdef.editor.edit.parts.CompartmentVisualFacetsEditPart;
import org.eclipse.gmf.graphdef.editor.edit.parts.ConnectionEditPart;
import org.eclipse.gmf.graphdef.editor.edit.parts.ConnectionNameEditPart;
import org.eclipse.gmf.graphdef.editor.edit.parts.ConnectionVisualFacetsEditPart;
import org.eclipse.gmf.graphdef.editor.edit.parts.DiagramElementFigureEditPart;
import org.eclipse.gmf.graphdef.editor.edit.parts.Ellipse2EditPart;
import org.eclipse.gmf.graphdef.editor.edit.parts.EllipseEditPart;
import org.eclipse.gmf.graphdef.editor.edit.parts.FigureGalleryEditPart;
import org.eclipse.gmf.graphdef.editor.edit.parts.FigureGalleryFiguresEditPart;
import org.eclipse.gmf.graphdef.editor.edit.parts.FigureGalleryNameEditPart;
import org.eclipse.gmf.graphdef.editor.edit.parts.NodeEditPart;
import org.eclipse.gmf.graphdef.editor.edit.parts.NodeNameEditPart;
import org.eclipse.gmf.graphdef.editor.edit.parts.NodeVisualFacetsEditPart;
import org.eclipse.gmf.graphdef.editor.edit.parts.Polyline2EditPart;
import org.eclipse.gmf.graphdef.editor.edit.parts.PolylineEditPart;
import org.eclipse.gmf.graphdef.editor.edit.parts.Rectangle2EditPart;
import org.eclipse.gmf.graphdef.editor.edit.parts.RectangleEditPart;
import org.eclipse.gmf.graphdef.editor.edit.parts.RoundedRectangle2EditPart;
import org.eclipse.gmf.graphdef.editor.edit.parts.RoundedRectangleEditPart;
import org.eclipse.gmf.graphdef.editor.part.GMFGraphVisualIDRegistry;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ITextAwareEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrapLabel;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Text;

public class GMFGraphEditPartFactory
implements EditPartFactory {
    public static final String EXTERNAL_NODE_LABELS_LAYER = "External Node Labels";

    public EditPart createEditPart(EditPart context, Object model) {
        if (model instanceof View) {
            View view = (View)model;
            int viewVisualID = GMFGraphVisualIDRegistry.getVisualID(view);
            switch (viewVisualID) {
                case 2001: {
                    return new CompartmentEditPart(view);
                }
                case 5001: {
                    return new CompartmentNameEditPart(view);
                }
                case 2002: {
                    return new NodeEditPart(view);
                }
                case 5002: {
                    return new NodeNameEditPart(view);
                }
                case 2003: {
                    return new ConnectionEditPart(view);
                }
                case 5003: {
                    return new ConnectionNameEditPart(view);
                }
                case 2004: {
                    return new FigureGalleryEditPart(view);
                }
                case 5004: {
                    return new FigureGalleryNameEditPart(view);
                }
                case 3001: {
                    return new RectangleEditPart(view);
                }
                case 3002: {
                    return new Rectangle2EditPart(view);
                }
                case 3003: {
                    return new EllipseEditPart(view);
                }
                case 3004: {
                    return new RoundedRectangleEditPart(view);
                }
                case 3005: {
                    return new PolylineEditPart(view);
                }
                case 3006: {
                    return new Ellipse2EditPart(view);
                }
                case 3007: {
                    return new RoundedRectangle2EditPart(view);
                }
                case 3008: {
                    return new Polyline2EditPart(view);
                }
                case 7001: {
                    return new CompartmentVisualFacetsEditPart(view);
                }
                case 7002: {
                    return new NodeVisualFacetsEditPart(view);
                }
                case 7003: {
                    return new ConnectionVisualFacetsEditPart(view);
                }
                case 7004: {
                    return new FigureGalleryFiguresEditPart(view);
                }
                case 1000: {
                    return new CanvasEditPart(view);
                }
                case 4001: {
                    return new DiagramElementFigureEditPart(view);
                }
            }
        }
        return this.createUnrecognizedEditPart(context, model);
    }

    private EditPart createUnrecognizedEditPart(EditPart context, Object model) {
        return null;
    }

    public static CellEditorLocator getTextCellEditorLocator(ITextAwareEditPart source) {
        if (source.getFigure() instanceof WrapLabel) {
            return new TextCellEditorLocator((WrapLabel)source.getFigure());
        }
        IFigure figure = source.getFigure();
        return new LabelCellEditorLocator((Label)figure);
    }

    private static class TextCellEditorLocator
    implements CellEditorLocator {
        private WrapLabel wrapLabel;

        public TextCellEditorLocator(WrapLabel wrapLabel) {
            this.wrapLabel = wrapLabel;
        }

        public WrapLabel getWrapLabel() {
            return this.wrapLabel;
        }

        public void relocate(CellEditor celleditor) {
            Text text = (Text)celleditor.getControl();
            Rectangle rect = this.getWrapLabel().getTextBounds().getCopy();
            this.getWrapLabel().translateToAbsolute((Translatable)rect);
            if (this.getWrapLabel().isTextWrapped() && this.getWrapLabel().getText().length() > 0) {
                rect.setSize(new Dimension(text.computeSize(rect.width, -1)));
            } else {
                int avr = FigureUtilities.getFontMetrics((Font)text.getFont()).getAverageCharWidth();
                rect.setSize(new Dimension(text.computeSize(-1, -1)).expand(avr * 2, 0));
            }
            if (!rect.equals((Object)new Rectangle(text.getBounds()))) {
                text.setBounds(rect.x, rect.y, rect.width, rect.height);
            }
        }
    }

    private static class LabelCellEditorLocator
    implements CellEditorLocator {
        private Label label;

        public LabelCellEditorLocator(Label label) {
            this.label = label;
        }

        public Label getLabel() {
            return this.label;
        }

        public void relocate(CellEditor celleditor) {
            Text text = (Text)celleditor.getControl();
            Rectangle rect = this.getLabel().getTextBounds().getCopy();
            this.getLabel().translateToAbsolute((Translatable)rect);
            int avr = FigureUtilities.getFontMetrics((Font)text.getFont()).getAverageCharWidth();
            rect.setSize(new Dimension(text.computeSize(-1, -1)).expand(avr * 2, 0));
            if (!rect.equals((Object)new Rectangle(text.getBounds()))) {
                text.setBounds(rect.x, rect.y, rect.width, rect.height);
            }
        }
    }
}

