/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.common;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.gmf.internal.common.AbstractNamesDispenser;

public class IncrementalNamesDispenser
extends AbstractNamesDispenser {
    private Set namesPool = new HashSet();
    private int initialIndex;

    public IncrementalNamesDispenser() {
        this.initialIndex = 2;
    }

    public IncrementalNamesDispenser(int initialIndex) {
        this.initialIndex = initialIndex;
    }

    protected final Collection getNamesPool() {
        return this.namesPool;
    }

    public String get(String prefixPart, String semanticPart, String suffixPart) {
        String name = IncrementalNamesDispenser.composeName(prefixPart, semanticPart, suffixPart);
        if (!this.contains(name)) {
            this.add(name);
            return name;
        }
        int i = this.initialIndex;
        while (i <= Integer.MAX_VALUE) {
            name = IncrementalNamesDispenser.composeName(prefixPart, String.valueOf(semanticPart) + i, suffixPart);
            if (!this.contains(name)) {
                this.add(name);
                return name;
            }
            ++i;
        }
        throw new IllegalStateException();
    }
}

