/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.bridge.ui.dashboard;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.gmf.internal.bridge.ui.dashboard.DashboardState;
import org.eclipse.ui.IMemento;

public class DashboardPersistence {
    private static final String DS_ELEMENT = "dashboardState";
    private static final String PROJECT_KEY = "project";
    private static final String DM_KEY = "domainModel";
    private static final String DGM_KEY = "domainGenerationModel";
    private static final String GDM_KEY = "graphicalDefinitionModel";
    private static final String TDM_KEY = "toolingDefinitionModel";
    private static final String MM_KEY = "mappingModel";
    private static final String GM_KEY = "generationModel";

    public static Map read(IMemento memento) {
        HashMap<IProject, DashboardState> states = new HashMap<IProject, DashboardState>();
        IMemento[] stateMementos = memento.getChildren(DS_ELEMENT);
        int i = 0;
        while (i < stateMementos.length) {
            IProject project;
            IMemento stateMemento = stateMementos[i];
            String projectName = stateMemento.getString(PROJECT_KEY);
            if (projectName != null && (project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName)).exists()) {
                DashboardState state = new DashboardState();
                state.dmFileName = stateMemento.getString(DM_KEY);
                state.dgmFileName = stateMemento.getString(DGM_KEY);
                state.gdmFileName = stateMemento.getString(GDM_KEY);
                state.tdmFileName = stateMemento.getString(TDM_KEY);
                state.mmFileName = stateMemento.getString(MM_KEY);
                state.gmFileName = stateMemento.getString(GM_KEY);
                states.put(project, state);
            }
            ++i;
        }
        return states;
    }

    public static void write(IMemento memento, Map states) {
        Iterator it = states.keySet().iterator();
        while (it.hasNext()) {
            IProject project = (IProject)it.next();
            DashboardState state = (DashboardState)states.get(project);
            IMemento stateMemento = memento.createChild(DS_ELEMENT);
            stateMemento.putString(PROJECT_KEY, project.getName());
            if (state.dmFileName != null) {
                stateMemento.putString(DM_KEY, state.dmFileName);
            }
            if (state.dgmFileName != null) {
                stateMemento.putString(DGM_KEY, state.dgmFileName);
            }
            if (state.gdmFileName != null) {
                stateMemento.putString(GDM_KEY, state.gdmFileName);
            }
            if (state.tdmFileName != null) {
                stateMemento.putString(TDM_KEY, state.tdmFileName);
            }
            if (state.mmFileName != null) {
                stateMemento.putString(MM_KEY, state.mmFileName);
            }
            if (state.gmFileName == null) continue;
            stateMemento.putString(GM_KEY, state.gmFileName);
        }
    }
}

