/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.validation.internal.service.impl.tests;

import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import junit.framework.TestCase;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.validation.model.EvaluationMode;
import org.eclipse.emf.validation.service.ModelValidationService;

public class TraversalStrategyManagerTest
extends TestCase {
    public TraversalStrategyManagerTest(String name) {
        super(name);
    }

    public void testTraversalStrategyManagerDoesNotLeakDynamicEPackages() {
        ResourceSetImpl rset = new ResourceSetImpl();
        ReferenceQueue queue = new ReferenceQueue();
        EObject thing = this.loadThing((ResourceSet)rset);
        PhantomReference<EPackage> ref = new PhantomReference<EPackage>(thing.eClass().getEPackage(), queue);
        ModelValidationService.getInstance().newValidator(EvaluationMode.BATCH).validate((Object)thing);
        for (Resource next : rset.getResources()) {
            next.unload();
        }
        rset.getResources().clear();
        thing = null;
        rset = null;
        Reference cleared = null;
        int i = 0;
        while (cleared == null && i < 5) {
            System.gc();
            try {
                cleared = queue.remove(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
        TraversalStrategyManagerTest.assertSame(ref, cleared);
    }

    EObject loadThing(ResourceSet rset) {
        Resource res = rset.getResource(URI.createPlatformPluginURI((String)"org.eclipse.emf.validation.tests/model/thing.xmi", (boolean)true), true);
        return (EObject)res.getContents().get(0);
    }
}

