/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.validation.internal.service.tests;

import ordersystem.Order;
import ordersystem.OrderSystemFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.validation.internal.service.tests.ClientContextValidationListener;
import org.eclipse.emf.validation.internal.service.tests.UniversalValidationListener;
import org.eclipse.emf.validation.service.ValidationEvent;
import org.eclipse.emf.validation.tests.AllTests;
import org.eclipse.emf.validation.tests.TestBase;
import org.eclipse.ui.PlatformUI;

public class ValidationListenersTest
extends TestBase {
    public ValidationListenersTest(String name) {
        super(name);
    }

    public void test_UniversalListener() {
        Order object = OrderSystemFactory.eINSTANCE.createOrder();
        this.batchValidator.validate((EObject)object);
        ValidationListenersTest.assertTrue((UniversalValidationListener.LAST_EVENT != null ? 1 : 0) != 0);
        ValidationEvent event = UniversalValidationListener.LAST_EVENT;
        ValidationListenersTest.assertTrue((boolean)event.getClientContextIds().contains("org.eclipse.emf.validation.tests.junit"));
    }

    public void test_ClientContextListener() {
        Order object = OrderSystemFactory.eINSTANCE.createOrder();
        this.batchValidator.validate((EObject)object);
        ValidationListenersTest.assertTrue((boolean)ClientContextValidationListener.LISTENER_CALLED);
    }

    public void liveValidationJUnitLockupTest() {
        AllTests.executingUnitTests = true;
        ResourceImpl r = new ResourceImpl();
        Order order = OrderSystemFactory.eINSTANCE.createOrder();
        r.getContents().add((Object)order);
        final Notification[] notification = new Notification[]{null};
        order.eAdapters().add((Object)new AdapterImpl(){

            public void notifyChanged(Notification msg) {
                notification[0] = msg;
            }
        });
        order.setId("id");
        assert (PlatformUI.isWorkbenchRunning()) : "The workbench must be up in order for this test to make any sense.";
        this.liveValidator.validate(notification[0]);
    }

    protected void setUp() throws Exception {
        super.setUp();
        ClientContextValidationListener.LISTENER_CALLED = false;
        UniversalValidationListener.LAST_EVENT = null;
        UniversalValidationListener.enabled = true;
    }

    protected void tearDown() throws Exception {
        UniversalValidationListener.enabled = false;
        UniversalValidationListener.LAST_EVENT = null;
        ClientContextValidationListener.LISTENER_CALLED = false;
        super.tearDown();
    }
}

