/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.emftvm.launcher;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.m2m.atl.adt.ui.common.RegisteredPackageDialog;
import org.eclipse.m2m.atl.adt.ui.common.WorkspaceFileDialog;
import org.eclipse.m2m.atl.emftvm.ModelDeclaration;
import org.eclipse.m2m.atl.emftvm.Module;
import org.eclipse.m2m.atl.emftvm.launcher.EMFTVMLaunchConfigurationDelegate;
import org.eclipse.m2m.atl.emftvm.launcher.EmftvmLauncherImages;
import org.eclipse.m2m.atl.emftvm.launcher.EmftvmLauncherPlugin;
import org.eclipse.m2m.atl.emftvm.util.ModuleNotFoundException;
import org.eclipse.m2m.atl.emftvm.util.ModuleResolver;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class MainEMFTVMTab
extends AbstractLaunchConfigurationTab {
    private ScrolledComposite scrollContainer;
    private Composite rootContainer;
    private Group moduleGroup;
    private Text moduleNameText;
    private Text modulePathText;
    private Group metamodelsGroup;
    private Group inputModelsGroup;
    private Group inoutModelsGroup;
    private Group outputModelsGroup;
    private Group controlGroup;
    private ILaunchConfiguration launchConfiguration;
    private Module module;
    private boolean moduleChanged;
    private final Map<List<String>, Module> moduleCache = new HashMap<List<String>, Module>();
    private final Map<String, Map<String, Object>> metamodelsGroupWidgets = new LinkedHashMap<String, Map<String, Object>>();
    private final Map<String, Map<String, Object>> inputModelsGroupWidgets = new LinkedHashMap<String, Map<String, Object>>();
    private final Map<String, Map<String, Object>> inoutModelsGroupWidgets = new LinkedHashMap<String, Map<String, Object>>();
    private final Map<String, Map<String, Object>> outputModelsGroupWidgets = new LinkedHashMap<String, Map<String, Object>>();
    private final Collection<String> removableMetamodels = new LinkedHashSet<String>();
    private final Collection<String> removableInputModels = new LinkedHashSet<String>();
    private final Collection<String> removableInoutModels = new LinkedHashSet<String>();
    private final Collection<String> removableOutputModels = new LinkedHashSet<String>();
    private final Map<String, String> metamodelLocations = new LinkedHashMap<String, String>();
    private final Map<String, String> inputModelLocations = new LinkedHashMap<String, String>();
    private final Map<String, String> inoutModelLocations = new LinkedHashMap<String, String>();
    private final Map<String, String> inoutModelOutLocations = new LinkedHashMap<String, String>();
    private final Map<String, String> outputModelLocations = new LinkedHashMap<String, String>();
    private final Map<String, String> metamodelOptions = new LinkedHashMap<String, String>();
    private final Map<String, String> inputModelOptions = new LinkedHashMap<String, String>();
    private final Map<String, String> inoutModelOptions = new LinkedHashMap<String, String>();
    private final Map<String, String> outputModelOptions = new LinkedHashMap<String, String>();

    public void createControl(Composite parent) {
        this.scrollContainer = new ScrolledComposite(parent, 768);
        this.scrollContainer.setExpandHorizontal(true);
        this.scrollContainer.setExpandVertical(true);
        this.rootContainer = new Composite((Composite)this.scrollContainer, 0);
        this.rootContainer.setLayout((Layout)new GridLayout());
        this.scrollContainer.setContent((Control)this.rootContainer);
        this.moduleGroup = new Group(this.rootContainer, 0);
        this.moduleGroup.setLayoutData((Object)new GridData(768));
        this.moduleGroup.setLayout((Layout)new GridLayout(3, false));
        this.moduleGroup.setText("EMFTVM module");
        Label moduleFileLabel = new Label((Composite)this.moduleGroup, 16384);
        moduleFileLabel.setLayoutData((Object)new GridData(16384));
        moduleFileLabel.setText("Module:");
        this.moduleNameText = new Text((Composite)this.moduleGroup, 2052);
        this.moduleNameText.setLayoutData((Object)new GridData(768));
        this.moduleNameText.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                if (MainEMFTVMTab.this.moduleChanged) {
                    MainEMFTVMTab.this.rebuild();
                }
            }

            public void focusGained(FocusEvent e) {
            }
        });
        this.moduleNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!MainEMFTVMTab.this.moduleChanged) {
                    MainEMFTVMTab.this.moduleChanged = true;
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            MainEMFTVMTab.this.rebuild();
                        }
                    });
                }
            }
        });
        Button browseWorkspace = new Button((Composite)this.moduleGroup, 131072);
        browseWorkspace.setText("Workspace...");
        browseWorkspace.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                Object result;
                String[] extensions = new String[]{"emftvm"};
                WorkspaceFileDialog dialog = new WorkspaceFileDialog(MainEMFTVMTab.this.getShell(), extensions);
                Object object = result = dialog.open() == 0 ? dialog.getFirstResult() : null;
                if (result != null && result instanceof IFile) {
                    IFile currentFile = (IFile)result;
                    IPath path = currentFile.getFullPath();
                    URI uri = URI.createPlatformResourceURI((String)path.toString(), (boolean)true);
                    Module module = MainEMFTVMTab.findModule(uri);
                    if (module != null) {
                        String mName = module.getName();
                        MainEMFTVMTab.this.moduleNameText.setText(mName);
                        int segments = 1;
                        int index = mName.indexOf("::");
                        while (index > -1) {
                            ++segments;
                            index = mName.indexOf("::", index + 1);
                        }
                        MainEMFTVMTab.this.modulePathText.setText(String.valueOf(path.removeLastSegments(segments).toString()) + '/');
                    } else {
                        MainEMFTVMTab.this.modulePathText.setText(String.valueOf(path.removeLastSegments(1).toString()) + '/');
                        MainEMFTVMTab.this.moduleNameText.setText(path.removeFileExtension().lastSegment());
                    }
                    MainEMFTVMTab.this.rebuild();
                }
            }
        });
        Label modulePathLabel = new Label((Composite)this.moduleGroup, 16384);
        modulePathLabel.setLayoutData((Object)new GridData(16384));
        modulePathLabel.setText("Path:");
        this.modulePathText = new Text((Composite)this.moduleGroup, 2052);
        GridData modulePathData = new GridData(768);
        modulePathData.horizontalSpan = 2;
        this.modulePathText.setLayoutData((Object)modulePathData);
        this.modulePathText.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                if (MainEMFTVMTab.this.moduleChanged) {
                    MainEMFTVMTab.this.rebuild();
                }
            }

            public void focusGained(FocusEvent e) {
            }
        });
        this.modulePathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!MainEMFTVMTab.this.moduleChanged) {
                    MainEMFTVMTab.this.moduleChanged = true;
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            MainEMFTVMTab.this.rebuild();
                        }
                    });
                }
            }
        });
        this.metamodelsGroup = new Group(this.rootContainer, 0);
        this.metamodelsGroup.setText("Metamodels");
        this.metamodelsGroup.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
        this.metamodelsGroup.setLayout((Layout)new GridLayout(8, false));
        this.inputModelsGroup = new Group(this.rootContainer, 0);
        this.inputModelsGroup.setText("Input models");
        this.inputModelsGroup.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
        this.inputModelsGroup.setLayout((Layout)new GridLayout(8, false));
        this.inoutModelsGroup = new Group(this.rootContainer, 0);
        this.inoutModelsGroup.setText("In/out models");
        this.inoutModelsGroup.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
        this.inoutModelsGroup.setLayout((Layout)new GridLayout(8, false));
        this.outputModelsGroup = new Group(this.rootContainer, 0);
        this.outputModelsGroup.setText("Output models");
        this.outputModelsGroup.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
        this.outputModelsGroup.setLayout((Layout)new GridLayout(8, false));
        this.controlGroup = new Group(this.rootContainer, 0);
        this.controlGroup.setText("Modify");
        this.controlGroup.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
        this.controlGroup.setLayout((Layout)new GridLayout(7, false));
        Button addMetaModelBtn = new Button((Composite)this.controlGroup, 0);
        addMetaModelBtn.setText("Add metamodel...");
        addMetaModelBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                InputDialog dlg = new InputDialog(MainEMFTVMTab.this.getShell(), "Add metamodel", "Metaodel name", "MM", null);
                if (dlg.open() == 1) {
                    return;
                }
                String modelName = dlg.getValue();
                if (!MainEMFTVMTab.this.metamodelLocations.containsKey(modelName)) {
                    MainEMFTVMTab.this.metamodelLocations.put(modelName, "");
                    MainEMFTVMTab.this.removableMetamodels.add(modelName);
                    MainEMFTVMTab.this.build();
                    MainEMFTVMTab.this.layout();
                }
            }
        });
        Button addInputModelBtn = new Button((Composite)this.controlGroup, 0);
        addInputModelBtn.setText("Add input model...");
        addInputModelBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                InputDialog dlg = new InputDialog(MainEMFTVMTab.this.getShell(), "Add input model", "Model name", "IN", null);
                if (dlg.open() == 1) {
                    return;
                }
                String modelName = dlg.getValue();
                if (!MainEMFTVMTab.this.inputModelLocations.containsKey(modelName)) {
                    MainEMFTVMTab.this.inputModelLocations.put(modelName, "");
                    MainEMFTVMTab.this.removableInputModels.add(modelName);
                    MainEMFTVMTab.this.build();
                    MainEMFTVMTab.this.layout();
                }
            }
        });
        Button addInoutModelBtn = new Button((Composite)this.controlGroup, 0);
        addInoutModelBtn.setText("Add in/out model...");
        addInoutModelBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                InputDialog dlg = new InputDialog(MainEMFTVMTab.this.getShell(), "Add in/out model", "Model name", "M", null);
                if (dlg.open() == 1) {
                    return;
                }
                String modelName = dlg.getValue();
                if (!MainEMFTVMTab.this.inoutModelLocations.containsKey(modelName)) {
                    MainEMFTVMTab.this.inoutModelLocations.put(modelName, "");
                    MainEMFTVMTab.this.removableInoutModels.add(modelName);
                    MainEMFTVMTab.this.build();
                    MainEMFTVMTab.this.layout();
                }
            }
        });
        Button addOutputModelBtn = new Button((Composite)this.controlGroup, 0);
        addOutputModelBtn.setText("Add output model...");
        addOutputModelBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                InputDialog dlg = new InputDialog(MainEMFTVMTab.this.getShell(), "Add output model", "Model name", "OUT", null);
                if (dlg.open() == 1) {
                    return;
                }
                String modelName = dlg.getValue();
                if (!MainEMFTVMTab.this.outputModelLocations.containsKey(modelName)) {
                    MainEMFTVMTab.this.outputModelLocations.put(modelName, "");
                    MainEMFTVMTab.this.removableOutputModels.add(modelName);
                    MainEMFTVMTab.this.build();
                    MainEMFTVMTab.this.layout();
                }
            }
        });
        this.setControl((Control)this.scrollContainer);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.launchConfiguration = configuration;
        try {
            String name = configuration.getAttribute("Module Name", "");
            String path = configuration.getAttribute("Module Path", "");
            String oldPath = configuration.getAttribute("Module File Name", "");
            if ((name.equals("") || path.equals("")) && !oldPath.equals("")) {
                int index = oldPath.lastIndexOf(47) + 1;
                path = oldPath.substring(0, index);
                int dotIndex = oldPath.lastIndexOf(46);
                String string = name = dotIndex < 0 ? oldPath.substring(index) : oldPath.substring(index, dotIndex);
            }
            if (!name.equals(this.moduleNameText.getText()) || !path.equals(this.modulePathText.getText())) {
                this.moduleChanged = true;
                this.moduleNameText.setText(name);
                this.modulePathText.setText(path);
            }
            this.rebuild();
        }
        catch (CoreException e) {
            EmftvmLauncherPlugin.log(e.getStatus());
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("Module Name", this.moduleNameText.getText());
        configuration.setAttribute("Module Path", this.modulePathText.getText());
        configuration.removeAttribute("Module File Name");
        if (this.module != null && this.module.eResource().getURI().isPlatformResource()) {
            URI moduleUri = this.module.eResource().getURI();
            configuration.setAttribute("ATL File Name", moduleUri.toPlatformString(true).replaceFirst("\\.emftvm$", ".atl"));
            Iterator it = this.module.getEImports().iterator();
            ArrayList<Iterator> its = new ArrayList<Iterator>();
            ArrayList<String> superimpose = new ArrayList<String>();
            HashSet<Module> processed = new HashSet<Module>();
            processed.add(this.module);
            Module m = null;
            do {
                if (it.hasNext()) {
                    m = (Module)it.next();
                    if (processed.contains(m)) continue;
                    its.add(it);
                    it = m.getEImports().iterator();
                    URI uri = m.eResource().getURI();
                    if (uri.isPlatformResource()) {
                        String mPath = uri.toPlatformString(true);
                        superimpose.add(mPath.replaceFirst("\\.emftvm$", ".asm"));
                    }
                    processed.add(m);
                    continue;
                }
                if (!its.isEmpty()) {
                    it = (Iterator)its.remove(its.size() - 1);
                    continue;
                }
                m = null;
            } while (m != null);
            configuration.setAttribute("Superimpose", superimpose);
        }
        configuration.setAttribute("Metamodels", new LinkedHashMap<String, String>(this.metamodelLocations));
        configuration.setAttribute("Input Models", new LinkedHashMap<String, String>(this.inputModelLocations));
        configuration.setAttribute("Inout Models", new LinkedHashMap<String, String>(this.inoutModelLocations));
        configuration.setAttribute("Inout Models Output Locations", new LinkedHashMap<String, String>(this.inoutModelOutLocations));
        configuration.setAttribute("Output Models", new LinkedHashMap<String, String>(this.outputModelLocations));
        configuration.setAttribute("Metamodel Options", new LinkedHashMap<String, String>(this.metamodelOptions));
        configuration.setAttribute("Input Model Options", new LinkedHashMap<String, String>(this.inputModelOptions));
        configuration.setAttribute("Inout Model Options", new LinkedHashMap<String, String>(this.inoutModelOptions));
        configuration.setAttribute("Output Model Options", new LinkedHashMap<String, String>(this.outputModelOptions));
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setErrorMessage(null);
        if (this.modulePathText.getText().equals("")) {
            this.setErrorMessage("No EMFTVM module given");
            return false;
        }
        for (Map.Entry<String, Map<String, Object>> entry : this.metamodelsGroupWidgets.entrySet()) {
            String mName = entry.getKey();
            Map<String, Object> widgets = entry.getValue();
            Text metamodelLocation = (Text)widgets.get("metamodelLocation");
            Button isMetametamodel = (Button)widgets.get("isMetametamodel");
            if (metamodelLocation.getText().length() != 0 || isMetametamodel.getSelection()) continue;
            this.setErrorMessage(String.format("No path given for %s", mName));
            return false;
        }
        return this.canSaveGroupWidgets(this.inputModelsGroupWidgets) && this.canSaveGroupWidgets(this.inoutModelsGroupWidgets) && this.canSaveGroupWidgets(this.outputModelsGroupWidgets) && super.isValid(launchConfig);
    }

    public String getName() {
        return "Main";
    }

    public Image getImage() {
        return EmftvmLauncherImages.get("org.eclipse.m2m.atl.emftvm.launcher.MAIN_TAB");
    }

    private boolean canSaveGroupWidgets(Map<String, Map<String, Object>> modelsGroupWidgets) {
        for (Map.Entry<String, Map<String, Object>> entry : modelsGroupWidgets.entrySet()) {
            String mName = entry.getKey();
            Map<String, Object> widgets = entry.getValue();
            Text location = (Text)widgets.get("location");
            if (location.getText().length() != 0) continue;
            this.setErrorMessage(String.format("No path given for %s", mName));
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    private void rebuild() {
        this.moduleChanged = false;
        try {
            this.clear();
            this.getModelsFromEMFTVMFile();
            this.build();
            this.loadValuesFrom(this.launchConfiguration);
            this.build();
            this.layout();
        }
        catch (CoreException e) {
            EmftvmLauncherPlugin.log(e.getStatus());
        }
    }

    private void build() {
        this.buildMetamodelControls();
        this.buildInputModelControls();
        this.buildInoutModelControls();
        this.buildOutputModelControls();
    }

    private void buildMetamodelControls() {
        for (Map.Entry<String, String> entry : this.metamodelLocations.entrySet()) {
            String modelName = entry.getKey();
            String modelLocation = entry.getValue();
            if (this.metamodelsGroupWidgets.containsKey(modelName)) continue;
            this.metamodelsGroupWidgets.put(modelName, this.buildMetamodelControls(this.metamodelsGroup, modelName, modelLocation, this.removableMetamodels.contains(modelName)));
        }
    }

    private void buildInputModelControls() {
        for (Map.Entry<String, String> entry : this.inputModelLocations.entrySet()) {
            String modelName = entry.getKey();
            String modelLocation = entry.getValue();
            if (this.inputModelsGroupWidgets.containsKey(modelName)) continue;
            this.inputModelsGroupWidgets.put(modelName, this.buildModelControls(this.inputModelsGroup, modelName, modelLocation, this.inputModelLocations, this.inputModelOptions, this.removableInputModels.contains(modelName), false, false));
        }
    }

    private void buildInoutModelControls() {
        for (Map.Entry<String, String> entry : this.inoutModelLocations.entrySet()) {
            String modelName = entry.getKey();
            String modelLocation = entry.getValue();
            if (this.inoutModelsGroupWidgets.containsKey(modelName)) continue;
            this.inoutModelsGroupWidgets.put(modelName, this.buildModelControls(this.inoutModelsGroup, modelName, modelLocation, this.inoutModelLocations, this.inoutModelOptions, this.removableInoutModels.contains(modelName), true, true));
        }
    }

    private void buildOutputModelControls() {
        for (Map.Entry<String, String> entry : this.outputModelLocations.entrySet()) {
            String modelName = entry.getKey();
            String modelLocation = entry.getValue();
            if (this.outputModelsGroupWidgets.get(modelName) != null) continue;
            this.outputModelsGroupWidgets.put(modelName, this.buildModelControls(this.outputModelsGroup, modelName, modelLocation, this.outputModelLocations, this.outputModelOptions, this.removableOutputModels.contains(modelName), true, false));
        }
    }

    private Map<String, Object> buildMetamodelControls(Group parent, final String metamodelName, String metamodelLocation, boolean removable) {
        Button delete;
        HashMap<String, Object> thisGroupWidgets = new HashMap<String, Object>();
        final Label metamodelLabel = new Label((Composite)parent, 0);
        metamodelLabel.setText(String.valueOf(metamodelName) + ":");
        final Text location = new Text((Composite)parent, 2048);
        location.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 6, 1));
        if (metamodelLocation != null) {
            location.setText(metamodelLocation);
        }
        location.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MainEMFTVMTab.this.metamodelLocations.put(metamodelName, location.getText());
                MainEMFTVMTab.this.updateLaunchConfigurationDialog();
            }
        });
        thisGroupWidgets.put("metamodelLocation", location);
        if (removable) {
            delete = new Button((Composite)parent, 0);
            delete.setText("Delete");
        } else {
            delete = null;
            new Label((Composite)parent, 0);
        }
        final Button isMetametamodel = new Button((Composite)parent, 32);
        isMetametamodel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 2, 1));
        isMetametamodel.setText("Is metametamodel");
        isMetametamodel.setToolTipText("Whether this is the root metamodel (Ecore)");
        isMetametamodel.setSelection(EMFTVMLaunchConfigurationDelegate.getBoolOption(this.metamodelOptions, metamodelName, "isMetametamodel"));
        thisGroupWidgets.put("isMetametamodel", isMetametamodel);
        final Button browseWorkspace = new Button((Composite)parent, 0);
        browseWorkspace.setText("Workspace...");
        browseWorkspace.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                Object result;
                WorkspaceFileDialog dialog = new WorkspaceFileDialog(MainEMFTVMTab.this.getShell(), null);
                Object object = result = dialog.open() == 0 ? dialog.getFirstResult() : null;
                if (result != null && result instanceof IFile) {
                    IFile currentFile = (IFile)result;
                    String path = currentFile.getFullPath().toString();
                    location.setText("platform:/resource" + path);
                }
            }
        });
        final Button browseFilesystem = new Button((Composite)parent, 0);
        browseFilesystem.setText("File system...");
        browseFilesystem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                FileDialog fileDialog = new FileDialog(MainEMFTVMTab.this.getShell(), 4096);
                fileDialog.setFilterExtensions(new String[]{"ecore"});
                String fileName = fileDialog.open();
                if (fileName != null) {
                    location.setText("file:/" + fileName);
                }
            }
        });
        final Button browseEMFRegistry = new Button((Composite)parent, 0);
        browseEMFRegistry.setText("EMF registry...");
        browseEMFRegistry.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                RegisteredPackageDialog dialog = new RegisteredPackageDialog(MainEMFTVMTab.this.getShell());
                if (dialog.open() == 0) {
                    location.setText(dialog.getResultAsString());
                }
            }
        });
        final Label filler = new Label((Composite)parent, 0);
        filler.setLayoutData((Object)new GridData(0, 0, false, false, 3, 1));
        location.setEnabled(!isMetametamodel.getSelection());
        browseWorkspace.setEnabled(!isMetametamodel.getSelection());
        browseFilesystem.setEnabled(!isMetametamodel.getSelection());
        browseEMFRegistry.setEnabled(!isMetametamodel.getSelection());
        isMetametamodel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                location.setEnabled(!isMetametamodel.getSelection());
                browseWorkspace.setEnabled(!isMetametamodel.getSelection());
                browseFilesystem.setEnabled(!isMetametamodel.getSelection());
                browseEMFRegistry.setEnabled(!isMetametamodel.getSelection());
                if (!isMetametamodel.getSelection()) {
                    EMFTVMLaunchConfigurationDelegate.unsetBoolOption(MainEMFTVMTab.this.metamodelOptions, metamodelName, "isMetametamodel");
                    location.notifyListeners(24, null);
                } else {
                    EMFTVMLaunchConfigurationDelegate.setBoolOption(MainEMFTVMTab.this.metamodelOptions, metamodelName, "isMetametamodel");
                }
                MainEMFTVMTab.this.updateLaunchConfigurationDialog();
            }
        });
        SelectionAdapter removeAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                MainEMFTVMTab.this.metamodelLocations.remove(metamodelName);
                MainEMFTVMTab.this.metamodelOptions.remove(metamodelName);
                MainEMFTVMTab.this.metamodelsGroupWidgets.remove(metamodelName);
                metamodelLabel.dispose();
                location.dispose();
                isMetametamodel.dispose();
                browseWorkspace.dispose();
                browseFilesystem.dispose();
                browseEMFRegistry.dispose();
                delete.dispose();
                filler.dispose();
                MainEMFTVMTab.this.layout();
            }
        };
        if (removable) {
            delete.addSelectionListener((SelectionListener)removeAdapter);
        }
        thisGroupWidgets.put("removeAdapter", removeAdapter);
        return thisGroupWidgets;
    }

    private Map<String, Object> buildModelControls(Group parent, final String modelName, String modelLocation, final Map<String, String> modelLocations, final Map<String, String> modelOptions, boolean removable, boolean output, boolean inout) {
        Button delete;
        Text outLocation;
        Text location;
        HashMap<String, Object> thisGroupWidgets = new HashMap<String, Object>();
        final ArrayList<Object> disposableWidgets = new ArrayList<Object>();
        Label modelLabel = new Label((Composite)parent, 0);
        modelLabel.setText(String.valueOf(modelName) + ":");
        disposableWidgets.add(modelLabel);
        if (inout) {
            location = new Text((Composite)parent, 2048);
            location.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
            if (modelLocation != null) {
                location.setText(modelLocation);
            }
            location.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    modelLocations.put(modelName, location.getText());
                    MainEMFTVMTab.this.updateLaunchConfigurationDialog();
                }
            });
            thisGroupWidgets.put("location", location);
            disposableWidgets.add(location);
            outLocation = new Text((Composite)parent, 2048);
            outLocation.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
            if (this.inoutModelOutLocations.get(modelName) != null) {
                outLocation.setText(this.inoutModelOutLocations.get(modelName));
            }
            outLocation.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    MainEMFTVMTab.this.inoutModelOutLocations.put(modelName, outLocation.getText());
                    MainEMFTVMTab.this.updateLaunchConfigurationDialog();
                }
            });
            thisGroupWidgets.put("outLocation", outLocation);
            disposableWidgets.add(outLocation);
        } else {
            location = new Text((Composite)parent, 2048);
            location.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 6, 1));
            if (modelLocation != null) {
                location.setText(modelLocation);
            }
            location.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    modelLocations.put(modelName, location.getText());
                    MainEMFTVMTab.this.updateLaunchConfigurationDialog();
                }
            });
            thisGroupWidgets.put("location", location);
            disposableWidgets.add(location);
            outLocation = null;
        }
        if (removable) {
            delete = new Button((Composite)parent, 0);
            delete.setText("Delete");
            disposableWidgets.add(delete);
        } else {
            delete = null;
            new Label((Composite)parent, 0);
        }
        Button browseWorkspace = new Button((Composite)parent, 0);
        browseWorkspace.setText("Workspace...");
        browseWorkspace.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 2, 1));
        browseWorkspace.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                Object result;
                WorkspaceFileDialog dialog = new WorkspaceFileDialog(MainEMFTVMTab.this.getShell(), null);
                Object object = result = dialog.open() == 0 ? dialog.getFirstResult() : null;
                if (result != null && result instanceof IFile) {
                    IFile currentFile = (IFile)result;
                    String path = currentFile.getFullPath().toString();
                    location.setText("platform:/resource" + path);
                    if (outLocation != null) {
                        outLocation.setText("platform:/resource" + path);
                    }
                }
            }
        });
        disposableWidgets.add(browseWorkspace);
        Button browseFilesystem = new Button((Composite)parent, 0);
        browseFilesystem.setText("File system...");
        browseFilesystem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                FileDialog fileDialog = new FileDialog(MainEMFTVMTab.this.getShell(), 4096);
                fileDialog.setFilterExtensions(new String[]{"*"});
                String fileName = fileDialog.open();
                if (fileName != null) {
                    location.setText("file:/" + fileName);
                    if (outLocation != null) {
                        outLocation.setText("file:/" + fileName);
                    }
                }
            }
        });
        disposableWidgets.add(browseFilesystem);
        if (output) {
            final Button allowInterModelReferences = new Button((Composite)parent, 32);
            allowInterModelReferences.setText("Allow Inter-model References");
            allowInterModelReferences.setSelection(EMFTVMLaunchConfigurationDelegate.getBoolOption(modelOptions, modelName, "allowIntermodelReferences"));
            allowInterModelReferences.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    if (allowInterModelReferences.getSelection()) {
                        EMFTVMLaunchConfigurationDelegate.setBoolOption(modelOptions, modelName, "allowIntermodelReferences");
                    } else {
                        EMFTVMLaunchConfigurationDelegate.unsetBoolOption(modelOptions, modelName, "allowIntermodelReferences");
                    }
                    MainEMFTVMTab.this.updateLaunchConfigurationDialog();
                }
            });
            thisGroupWidgets.put("allowInterModelReferences", allowInterModelReferences);
            disposableWidgets.add(allowInterModelReferences);
            final Button derivedFile = new Button((Composite)parent, 32);
            derivedFile.setText("Set File As Derived");
            derivedFile.setSelection(EMFTVMLaunchConfigurationDelegate.getBoolOption(modelOptions, modelName, "derivedFile"));
            derivedFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    if (derivedFile.getSelection()) {
                        EMFTVMLaunchConfigurationDelegate.setBoolOption(modelOptions, modelName, "derivedFile");
                    } else {
                        EMFTVMLaunchConfigurationDelegate.unsetBoolOption(modelOptions, modelName, "derivedFile");
                    }
                    MainEMFTVMTab.this.updateLaunchConfigurationDialog();
                }
            });
            thisGroupWidgets.put("derivedFile", derivedFile);
            disposableWidgets.add(derivedFile);
            if (inout) {
                final Button createNewModel = new Button((Composite)parent, 32);
                createNewModel.setText("Create New Model");
                createNewModel.setSelection(EMFTVMLaunchConfigurationDelegate.getBoolOption(modelOptions, modelName, "createNewModel"));
                location.setEnabled(!createNewModel.getSelection());
                createNewModel.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        location.setEnabled(!createNewModel.getSelection());
                        if (createNewModel.getSelection()) {
                            EMFTVMLaunchConfigurationDelegate.setBoolOption(modelOptions, modelName, "createNewModel");
                        } else {
                            EMFTVMLaunchConfigurationDelegate.unsetBoolOption(modelOptions, modelName, "createNewModel");
                        }
                        MainEMFTVMTab.this.updateLaunchConfigurationDialog();
                    }
                });
                thisGroupWidgets.put("createNewModel", createNewModel);
                disposableWidgets.add(createNewModel);
                Label filler = new Label((Composite)parent, 0);
                filler.setLayoutData((Object)new GridData(0, 0, false, false, 2, 1));
                disposableWidgets.add(filler);
            } else {
                Label filler = new Label((Composite)parent, 0);
                filler.setLayoutData((Object)new GridData(0, 0, false, false, 3, 1));
                disposableWidgets.add(filler);
            }
        } else {
            Label filler = new Label((Composite)parent, 0);
            filler.setLayoutData((Object)new GridData(0, 0, false, false, 5, 1));
            disposableWidgets.add(filler);
        }
        SelectionAdapter removeAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                if (MainEMFTVMTab.this.inputModelsGroupWidgets.get(modelName) != null) {
                    MainEMFTVMTab.this.inputModelsGroupWidgets.remove(modelName);
                    MainEMFTVMTab.this.inputModelLocations.remove(modelName);
                    MainEMFTVMTab.this.removableInputModels.remove(modelName);
                    MainEMFTVMTab.this.inputModelOptions.remove(modelName);
                } else if (MainEMFTVMTab.this.inoutModelsGroupWidgets.get(modelName) != null) {
                    MainEMFTVMTab.this.inoutModelsGroupWidgets.remove(modelName);
                    MainEMFTVMTab.this.inoutModelLocations.remove(modelName);
                    MainEMFTVMTab.this.inoutModelOutLocations.remove(modelName);
                    MainEMFTVMTab.this.removableInoutModels.remove(modelName);
                    MainEMFTVMTab.this.inoutModelOptions.remove(modelName);
                } else if (MainEMFTVMTab.this.outputModelsGroupWidgets.get(modelName) != null) {
                    MainEMFTVMTab.this.outputModelsGroupWidgets.remove(modelName);
                    MainEMFTVMTab.this.outputModelLocations.remove(modelName);
                    MainEMFTVMTab.this.removableOutputModels.remove(modelName);
                    MainEMFTVMTab.this.outputModelOptions.remove(modelName);
                }
                for (Widget widget : disposableWidgets) {
                    widget.dispose();
                }
                MainEMFTVMTab.this.layout();
            }
        };
        if (removable) {
            delete.addSelectionListener((SelectionListener)removeAdapter);
        }
        thisGroupWidgets.put("removeAdapter", removeAdapter);
        return thisGroupWidgets;
    }

    private void layout() {
        this.metamodelsGroup.layout();
        this.inputModelsGroup.layout();
        this.inoutModelsGroup.layout();
        this.outputModelsGroup.layout();
        this.rootContainer.layout();
        this.scrollContainer.setMinSize(this.rootContainer.computeSize(-1, -1));
        this.scrollContainer.layout();
        this.updateLaunchConfigurationDialog();
    }

    private synchronized void getModelsFromEMFTVMFile() {
        if (!this.modulePathText.getText().equals("") && !this.moduleNameText.getText().equals("")) {
            ArrayList<String> sig = new ArrayList<String>(2);
            sig.add(this.modulePathText.getText());
            sig.add(this.moduleNameText.getText());
            if (this.moduleCache.containsKey(sig)) {
                this.module = this.moduleCache.get(sig);
            } else {
                this.module = this.loadModule(this.modulePathText.getText(), this.moduleNameText.getText());
                this.moduleCache.put(sig, this.module);
            }
            if (this.module != null) {
                this.getModelsFromEMFTVMModule(this.module, new HashSet<Module>());
            }
        } else {
            this.module = null;
        }
    }

    private void getModelsFromEMFTVMModule(Module module, Set<Module> processed) {
        processed.add(module);
        for (Module imported : module.getEImports()) {
            if (processed.contains(imported)) continue;
            this.getModelsFromEMFTVMModule(imported, processed);
        }
        this.addModelsFromModelDeclarations((Collection<ModelDeclaration>)module.getInputModels(), this.inputModelLocations);
        this.addModelsFromModelDeclarations((Collection<ModelDeclaration>)module.getInoutModels(), this.inoutModelLocations);
        this.addModelsFromModelDeclarations((Collection<ModelDeclaration>)module.getOutputModels(), this.outputModelLocations);
        this.inputModelLocations.keySet().removeAll(this.inoutModelLocations.keySet());
        this.outputModelLocations.keySet().removeAll(this.inoutModelLocations.keySet());
    }

    private void addModelsFromModelDeclarations(Collection<ModelDeclaration> mds, Map<String, String> modelLocations) {
        for (ModelDeclaration md : mds) {
            String modelName = md.getModelName();
            String metamodelName = md.getMetaModelName();
            if (!modelLocations.containsKey(modelName)) {
                modelLocations.put(modelName, "");
            }
            if (this.metamodelLocations.containsKey(metamodelName)) continue;
            this.metamodelLocations.put(metamodelName, "");
        }
    }

    private Module loadModule(String path, String name) {
        ModuleResolver resolver = EMFTVMLaunchConfigurationDelegate.createModuleResolver(path);
        try {
            Module module = resolver.resolveModule(name);
            HashMap<String, Module> modules = new HashMap<String, Module>();
            modules.put(name, module);
            this.resolveImports(module, resolver, modules);
            return module;
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (ModuleNotFoundException moduleNotFoundException) {}
        return null;
    }

    private void resolveImports(Module module, ModuleResolver resolver, Map<String, Module> modules) {
        EList eImports = module.getEImports();
        for (String imp : module.getImports()) {
            Module impModule = modules.get(imp);
            if (impModule == null) {
                impModule = resolver.resolveModule(imp);
                modules.put(imp, impModule);
                this.resolveImports(impModule, resolver, modules);
            }
            eImports.add((Object)impModule);
        }
    }

    private void clear() {
        this.removableMetamodels.clear();
        this.removableInputModels.clear();
        this.removableInoutModels.clear();
        this.removableOutputModels.clear();
        this.metamodelLocations.clear();
        this.inputModelLocations.clear();
        this.inoutModelLocations.clear();
        this.inoutModelOutLocations.clear();
        this.outputModelLocations.clear();
        this.metamodelOptions.clear();
        this.inputModelOptions.clear();
        this.inoutModelOptions.clear();
        this.outputModelOptions.clear();
        this.metamodelsGroupWidgets.clear();
        this.inputModelsGroupWidgets.clear();
        this.inoutModelsGroupWidgets.clear();
        this.outputModelsGroupWidgets.clear();
        this.disposeGroupChildren(this.metamodelsGroup);
        this.disposeGroupChildren(this.inputModelsGroup);
        this.disposeGroupChildren(this.inoutModelsGroup);
        this.disposeGroupChildren(this.outputModelsGroup);
    }

    private void disposeGroupChildren(Group group) {
        Control[] controlArray = group.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.dispose();
            ++n2;
        }
    }

    private void loadValuesFrom(ILaunchConfiguration configuration) throws CoreException {
        String uri;
        String name;
        if (configuration == null) {
            return;
        }
        Map meta = configuration.getAttribute("Metamodels", Collections.EMPTY_MAP);
        Map input = configuration.getAttribute("Input Models", Collections.EMPTY_MAP);
        Map inout = configuration.getAttribute("Inout Models", Collections.EMPTY_MAP);
        Map inoutOut = configuration.getAttribute("Inout Models Output Locations", Collections.EMPTY_MAP);
        Map output = configuration.getAttribute("Output Models", Collections.EMPTY_MAP);
        this.metamodelOptions.putAll(configuration.getAttribute("Metamodel Options", Collections.EMPTY_MAP));
        this.inputModelOptions.putAll(configuration.getAttribute("Input Model Options", Collections.EMPTY_MAP));
        this.inoutModelOptions.putAll(configuration.getAttribute("Inout Model Options", Collections.EMPTY_MAP));
        this.outputModelOptions.putAll(configuration.getAttribute("Output Model Options", Collections.EMPTY_MAP));
        for (Map.Entry entry : meta.entrySet()) {
            name = (String)entry.getKey();
            uri = (String)entry.getValue();
            if (!this.metamodelLocations.containsKey(name)) {
                this.removableMetamodels.add(name);
            } else {
                ((Text)this.metamodelsGroupWidgets.get(name).get("metamodelLocation")).setText(uri);
                ((Button)this.metamodelsGroupWidgets.get(name).get("isMetametamodel")).setSelection(EMFTVMLaunchConfigurationDelegate.getBoolOption(this.metamodelOptions, name, "isMetametamodel"));
            }
            this.metamodelLocations.put(name, uri);
        }
        for (Map.Entry entry : input.entrySet()) {
            name = (String)entry.getKey();
            uri = (String)entry.getValue();
            if (!this.inputModelLocations.containsKey(name)) {
                this.removableInputModels.add(name);
            } else {
                ((Text)this.inputModelsGroupWidgets.get(name).get("location")).setText(uri);
            }
            this.inputModelLocations.put(name, uri);
        }
        for (Map.Entry entry : inout.entrySet()) {
            name = (String)entry.getKey();
            uri = (String)entry.getValue();
            if (!this.inoutModelOptions.containsKey(name)) {
                this.inoutModelOptions.put(name, "allowIntermodelReferences derivedFile");
            }
            if (!this.inoutModelLocations.containsKey(name)) {
                this.removableInoutModels.add(name);
            } else {
                ((Text)this.inoutModelsGroupWidgets.get(name).get("location")).setText(uri);
                ((Text)this.inoutModelsGroupWidgets.get(name).get("location")).setEnabled(!EMFTVMLaunchConfigurationDelegate.getBoolOption(this.inoutModelOptions, name, "createNewModel"));
                if (inoutOut.get(name) != null) {
                    ((Text)this.inoutModelsGroupWidgets.get(name).get("outLocation")).setText((String)inoutOut.get(name));
                } else {
                    ((Text)this.inoutModelsGroupWidgets.get(name).get("outLocation")).setText(uri);
                }
                ((Button)this.inoutModelsGroupWidgets.get(name).get("allowInterModelReferences")).setSelection(EMFTVMLaunchConfigurationDelegate.getBoolOption(this.inoutModelOptions, name, "allowIntermodelReferences"));
                ((Button)this.inoutModelsGroupWidgets.get(name).get("derivedFile")).setSelection(EMFTVMLaunchConfigurationDelegate.getBoolOption(this.inoutModelOptions, name, "derivedFile"));
                ((Button)this.inoutModelsGroupWidgets.get(name).get("createNewModel")).setSelection(EMFTVMLaunchConfigurationDelegate.getBoolOption(this.inoutModelOptions, name, "createNewModel"));
            }
            this.inoutModelLocations.put(name, uri);
            this.inoutModelOutLocations.put(name, (String)inoutOut.get(name));
        }
        for (Map.Entry entry : output.entrySet()) {
            name = (String)entry.getKey();
            uri = (String)entry.getValue();
            if (!this.outputModelOptions.containsKey(name)) {
                this.outputModelOptions.put(name, "allowIntermodelReferences derivedFile");
            }
            if (!this.outputModelLocations.containsKey(name)) {
                this.removableOutputModels.add(name);
            } else {
                ((Text)this.outputModelsGroupWidgets.get(name).get("location")).setText(uri);
                ((Button)this.outputModelsGroupWidgets.get(name).get("allowInterModelReferences")).setSelection(EMFTVMLaunchConfigurationDelegate.getBoolOption(this.outputModelOptions, name, "allowIntermodelReferences"));
                ((Button)this.outputModelsGroupWidgets.get(name).get("derivedFile")).setSelection(EMFTVMLaunchConfigurationDelegate.getBoolOption(this.outputModelOptions, name, "derivedFile"));
            }
            this.outputModelLocations.put(name, uri);
        }
    }

    private static Module findModule(URI uri) {
        ResourceSetImpl rs = new ResourceSetImpl();
        try {
            Resource r = rs.getResource(uri, true);
            for (EObject eo : r.getContents()) {
                if (!(eo instanceof Module)) continue;
                return (Module)eo;
            }
        }
        catch (Exception exception) {}
        return null;
    }
}

