/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.rest.client.tck.ssl;

import jakarta.inject.Inject;
import jakarta.ws.rs.ProcessingException;
import java.security.KeyStore;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import org.eclipse.microprofile.rest.client.RestClientBuilder;
import org.eclipse.microprofile.rest.client.inject.RestClient;
import org.eclipse.microprofile.rest.client.tck.interfaces.JsonPClient;
import org.eclipse.microprofile.rest.client.tck.interfaces.ssl.ConfigurableHostnameVerifier;
import org.eclipse.microprofile.rest.client.tck.ssl.AbstractSslTest;
import org.eclipse.microprofile.rest.client.tck.ssl.HttpsServer;
import org.eclipse.microprofile.rest.client.tck.utils.ConfigUtil;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.ClassLoaderAsset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SslHostnameVerifierTest
extends AbstractSslTest {
    @Inject
    @RestClient
    private JsonPClient clientWithHostnameVerifier;

    @Deployment
    public static WebArchive createDeployment() {
        String config = ConfigUtil.configLine(JsonPClient.class, "uri", BASE_URI_STRING) + ConfigUtil.configLine(JsonPClient.class, "hostnameVerifier", ConfigurableHostnameVerifier.class.getCanonicalName()) + ConfigUtil.configLine(JsonPClient.class, "trustStore", "classpath:/META-INF/" + clientWrongHostnameTruststoreFromClasspath) + ConfigUtil.configLine(JsonPClient.class, "trustStoreType", "pkcs12") + ConfigUtil.configLine(JsonPClient.class, "trustStorePassword", "password");
        WebArchive webArchive = (WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)(SslHostnameVerifierTest.class.getSimpleName() + ".war"))).addClasses(new Class[]{JsonPClient.class, HttpsServer.class, AbstractSslTest.class, ConfigurableHostnameVerifier.class})).addAsWebInfResource((Asset)new StringAsset(config), "classes/META-INF/microprofile-config.properties")).addAsWebInfResource((Asset)new ClassLoaderAsset("ssl/" + clientWrongHostnameTruststoreFromClasspath), "classes/META-INF/" + clientWrongHostnameTruststoreFromClasspath)).addAsWebInfResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        SslHostnameVerifierTest.initializeTest(webArchive, server -> server.keyStore(serverWrongHostnameKeystore.getAbsolutePath(), "password"));
        return webArchive;
    }

    @Test(expectedExceptions={ProcessingException.class})
    public void shouldFailWithoutHostnameAndNoVerifier() throws Exception {
        KeyStore trustStore = SslHostnameVerifierTest.getKeyStore(clientWrongHostnameTruststore);
        ((JsonPClient)RestClientBuilder.newBuilder().baseUri(BASE_URI).trustStore(trustStore).build(JsonPClient.class)).get("1");
    }

    @Test(expectedExceptions={ProcessingException.class})
    public void shouldFailWithRejectingHostnameVerifier() throws Exception {
        KeyStore trustStore = SslHostnameVerifierTest.getKeyStore(clientWrongHostnameTruststore);
        ((JsonPClient)RestClientBuilder.newBuilder().baseUri(BASE_URI).trustStore(trustStore).hostnameVerifier((s, sslSession) -> false).build(JsonPClient.class)).get("1");
    }

    @Test
    public void shouldSucceedWithAcceptingHostnameVerifier() throws Exception {
        KeyStore trustStore = SslHostnameVerifierTest.getKeyStore(clientWrongHostnameTruststore);
        JsonPClient client = (JsonPClient)RestClientBuilder.newBuilder().baseUri(BASE_URI).trustStore(trustStore).hostnameVerifier((s, sslSession) -> true).build(JsonPClient.class);
        Assert.assertEquals((String)"bar", (String)client.get("1").getString("foo"));
    }

    @Test
    public void shouldPassSslSessionAndHostnameToHostnameVerifier() throws Exception {
        KeyStore trustStore = SslHostnameVerifierTest.getKeyStore(clientWrongHostnameTruststore);
        JsonPClient client = (JsonPClient)RestClientBuilder.newBuilder().baseUri(BASE_URI).trustStore(trustStore).hostnameVerifier(this::verifySslSessionAndHostname).build(JsonPClient.class);
        Assert.assertEquals((String)"bar", (String)client.get("1").getString("foo"));
    }

    @Test(expectedExceptions={ProcessingException.class})
    public void shouldFailWithRejectingHostnameVerifierCDI() {
        ConfigurableHostnameVerifier.setAccepting(false);
        this.clientWithHostnameVerifier.get("1");
    }

    @Test
    public void shouldSucceedWithAcceptingHostnameVerifierCDI() {
        ConfigurableHostnameVerifier.setAccepting(true);
        Assert.assertEquals((String)"bar", (String)this.clientWithHostnameVerifier.get("1").getString("foo"));
    }

    @Test
    public void shouldPassSslSessionAndHostnameToHostnameVerifierCDI() {
        ConfigurableHostnameVerifier.setAccepting(true);
        Assert.assertEquals((String)"bar", (String)this.clientWithHostnameVerifier.get("1").getString("foo"));
        this.verifySslSessionAndHostname(ConfigurableHostnameVerifier.getHostname(), ConfigurableHostnameVerifier.getSslSession());
    }

    private boolean verifySslSessionAndHostname(String hostname, SSLSession sslSession) {
        try {
            Assert.assertEquals((String)"localhost", (String)hostname);
            Assert.assertNotNull((Object)sslSession);
            Assert.assertNotNull((Object)sslSession.getCipherSuite());
            Assert.assertNotNull((Object)sslSession.getPeerCertificates());
            return true;
        }
        catch (SSLPeerUnverifiedException e) {
            throw new RuntimeException("failed to verify ssl session and hostname", e);
        }
    }
}

