/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.reactive.messaging.tck.connector;

import java.util.ServiceLoader;
import javax.enterprise.inject.spi.DeploymentException;
import org.eclipse.microprofile.reactive.messaging.tck.ArchiveExtender;
import org.eclipse.microprofile.reactive.messaging.tck.connector.DummyConnector;
import org.eclipse.microprofile.reactive.messaging.tck.connector.MyProcessor;
import org.eclipse.microprofile.reactive.messaging.tck.connector.MyProcessorWithBadStreamName;
import org.jboss.arquillian.container.test.api.Deployer;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.ShouldThrowException;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class MissingConnectorTest {
    @ArquillianResource
    private Deployer deployer;

    @Deployment(managed=false, name="missing-connector")
    @ShouldThrowException(value=DeploymentException.class, testable=true)
    public static Archive<JavaArchive> missingConnectorDeployment() {
        JavaArchive archive = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{MyProcessor.class, ArchiveExtender.class})).addAsManifestResource(MissingConnectorTest.class.getResource("connector-config.properties"), "microprofile-config.properties")).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        ServiceLoader.load(ArchiveExtender.class).iterator().forEachRemaining(ext -> ext.extend(archive));
        return archive;
    }

    @Test
    public void testWhenTheConnectorAreNotConfigured() {
        this.deployer.deploy("missing-connector");
    }

    @Deployment(managed=false, name="missing-stream")
    @ShouldThrowException(value=DeploymentException.class, testable=true)
    public static Archive<JavaArchive> missingStreamDeployment() {
        JavaArchive archive = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{MyProcessorWithBadStreamName.class, DummyConnector.class, ArchiveExtender.class})).addAsManifestResource(MissingConnectorTest.class.getResource("connector-config.properties"), "microprofile-config.properties")).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        ServiceLoader.load(ArchiveExtender.class).iterator().forEachRemaining(ext -> ext.extend(archive));
        return archive;
    }

    @Test
    public void testWhenTheStreamNameDoesNotMatch() {
        this.deployer.deploy("missing-stream");
    }
}

