/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.reactive.messaging.tck.connector;

import java.lang.annotation.Annotation;
import java.util.ServiceLoader;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.awaitility.Awaitility;
import org.eclipse.microprofile.reactive.messaging.spi.ConnectorLiteral;
import org.eclipse.microprofile.reactive.messaging.tck.ArchiveExtender;
import org.eclipse.microprofile.reactive.messaging.tck.connector.DummyConnector;
import org.eclipse.microprofile.reactive.messaging.tck.connector.MyProcessor;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class ConnectorTest {
    @Inject
    private BeanManager manager;

    @Deployment
    public static Archive<JavaArchive> deployment() {
        JavaArchive archive = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{DummyConnector.class, MyProcessor.class, ArchiveExtender.class})).addAsManifestResource(ConnectorTest.class.getResource("connector-config.properties"), "microprofile-config.properties")).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        ServiceLoader.load(ArchiveExtender.class).iterator().forEachRemaining(ext -> ext.extend(archive));
        return archive;
    }

    @Test
    public void checkConnector() {
        DummyConnector connector = (DummyConnector)this.manager.createInstance().select(DummyConnector.class, new Annotation[]{ConnectorLiteral.of((String)"Dummy")}).get();
        Awaitility.await().until(() -> connector.elements().size() == 10);
        Assertions.assertThat(connector.elements()).containsExactly((Object[])new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J"});
        ((ListAssert)Assertions.assertThat(connector.getReceivedConfigurations()).hasSizeBetween(2, 3)).allSatisfy(config -> {
            Assertions.assertThat((String)((String)config.getValue("common-A", String.class))).isEqualTo("Value-A");
            Assertions.assertThat((String)((String)config.getValue("common-B", String.class))).isEqualTo("Value-B");
        });
        Assertions.assertThat(connector.getReceivedConfigurations()).extracting(c -> (String)c.getValue("channel-name", String.class)).contains((Object[])new String[]{"dummy-source", "dummy-sink"});
    }
}

