/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.opentracing.tck.rest.client;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import org.eclipse.microprofile.opentracing.tck.rest.client.ClientServices;
import org.eclipse.microprofile.opentracing.tck.rest.client.ClientServicesTracingDisabled;
import org.eclipse.microprofile.rest.client.RestClientBuilder;

@Path(value="mpRestClient")
public class RestClientServices {
    public static final String REST_SERVICE_PATH = "mpRestClient";
    public static final String REST_NESTED_MP_REST_CLIENT = "nestedMpRestClient";
    public static final String REST_MP_REST_CLIENT_DISABLED_TRACING = "restClientTracingDisabled";
    public static final String REST_MP_REST_CLIENT_DISABLED_TRACING_METHOD = "restClientMethodTracingDisabled";
    @Context
    private UriInfo uri;

    @GET
    @Path(value="restClientTracingDisabled")
    @Produces(value={"text/plain"})
    public Response restClientTracingDisabled() throws MalformedURLException {
        URL webServicesUrl = new URL(this.getBaseURL().toString() + "rest/" + "testServices");
        ClientServicesTracingDisabled client = (ClientServicesTracingDisabled)RestClientBuilder.newBuilder().baseUrl(webServicesUrl).build(ClientServicesTracingDisabled.class);
        client.restSimpleTest();
        return Response.ok().build();
    }

    @GET
    @Path(value="restClientMethodTracingDisabled")
    @Produces(value={"text/plain"})
    public Response restClientMethodTracingDisabled() throws MalformedURLException {
        URL webServicesUrl = new URL(this.getBaseURL().toString() + "rest/" + "testServices");
        ClientServices client = (ClientServices)RestClientBuilder.newBuilder().baseUrl(webServicesUrl).build(ClientServices.class);
        client.disabledTracing();
        return Response.ok().build();
    }

    @GET
    @Path(value="nestedMpRestClient")
    @Produces(value={"text/plain"})
    public Response nestedMpRestClient(@QueryParam(value="nestDepth") int nestDepth, @QueryParam(value="nestBreadth") int nestBreadth, @QueryParam(value="data") String uniqueID, @QueryParam(value="failNest") boolean failNest, @QueryParam(value="async") boolean async) throws MalformedURLException, ExecutionException, InterruptedException {
        if (nestDepth > 0) {
            for (int i = 0; i < nestBreadth; ++i) {
                this.executeNestedMpRestClient(nestDepth - 1, 1, uniqueID, async);
            }
        }
        return Response.ok().build();
    }

    private void executeNestedMpRestClient(int depth, int breath, String id, boolean async) throws MalformedURLException, InterruptedException, ExecutionException {
        URL webServicesUrl = new URL(this.getBaseURL().toString() + "rest/" + REST_SERVICE_PATH);
        ClientServices clientServices = (ClientServices)RestClientBuilder.newBuilder().baseUrl(webServicesUrl).executorService(Executors.newFixedThreadPool(50)).build(ClientServices.class);
        if (async) {
            CompletionStage<Response> completionStage = clientServices.executeNestedAsync(depth, breath, async, id, false);
            completionStage.toCompletableFuture().get();
        } else {
            clientServices.executeNested(depth, breath, async, id, false).close();
        }
    }

    private URL getBaseURL() {
        URL incomingURL;
        String incomingURLValue = this.uri.getAbsolutePath().toString();
        int i = incomingURLValue.indexOf("rest");
        if (i == -1) {
            throw new RuntimeException("Expecting rest in " + incomingURLValue);
        }
        try {
            incomingURL = new URL(incomingURLValue.substring(0, i));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        return incomingURL;
    }
}

