/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.opentracing.tck;

import io.opentracing.tag.Tags;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Response;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.eclipse.microprofile.opentracing.tck.OpenTracingBaseTests;
import org.eclipse.microprofile.opentracing.tck.application.TestAnnotatedClass;
import org.eclipse.microprofile.opentracing.tck.application.TestAnnotatedMethods;
import org.eclipse.microprofile.opentracing.tck.application.TestDisabledAnnotatedClass;
import org.eclipse.microprofile.opentracing.tck.application.TestServerWebServices;
import org.eclipse.microprofile.opentracing.tck.tracer.TestSpan;
import org.eclipse.microprofile.opentracing.tck.tracer.TestSpanTree;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.testng.annotations.Test;

public abstract class OpenTracingClientBaseTests
extends OpenTracingBaseTests {
    @Test
    @RunAsClient
    private void testStandardTags() throws InterruptedException {
        Response response = this.executeRemoteWebServiceRaw("testServices", "simpleTest", Response.Status.OK);
        response.close();
        TestSpanTree spans = this.executeRemoteWebServiceTracerTree();
        TestSpanTree expectedTree = new TestSpanTree(new TestSpanTree.TreeNode<TestSpan>(new TestSpan(this.getOperationName("server", "GET", TestServerWebServices.class, this.getEndpointMethod(TestServerWebServices.class, "simpleTest")), this.getExpectedSpanTags("server", "GET", "testServices", "simpleTest", null, Response.Status.OK.getStatusCode(), "jaxrs"), Collections.emptyList()), new TestSpanTree.TreeNode[0]));
        this.assertEqualTrees(spans, expectedTree);
    }

    @Test
    @RunAsClient
    private void testAnnotations() throws InterruptedException {
        Response response = this.executeRemoteWebServiceRaw("testServices", "annotations", Response.Status.OK);
        response.close();
        TestSpanTree spans = this.executeRemoteWebServiceTracerTree();
        TestSpanTree expectedTree = new TestSpanTree(new TestSpanTree.TreeNode<TestSpan>(new TestSpan(this.getOperationName("server", "GET", TestServerWebServices.class, this.getEndpointMethod(TestServerWebServices.class, "annotations")), this.getExpectedSpanTags("server", "GET", "testServices", "annotations", null, Response.Status.OK.getStatusCode(), "jaxrs"), Collections.emptyList()), new TestSpanTree.TreeNode<TestSpan>(new TestSpan(TestAnnotatedClass.class.getName() + ".annotatedClassMethodImplicitlyTraced", Collections.emptyMap(), Collections.emptyList()), new TestSpanTree.TreeNode[0]), new TestSpanTree.TreeNode<TestSpan>(new TestSpan("explicitOperationName1", Collections.emptyMap(), Collections.emptyList()), new TestSpanTree.TreeNode[0]), new TestSpanTree.TreeNode<TestSpan>(new TestSpan(TestAnnotatedMethods.class.getName() + ".annotatedMethodExplicitlyTraced", Collections.emptyMap(), Collections.emptyList()), new TestSpanTree.TreeNode[0]), new TestSpanTree.TreeNode<TestSpan>(new TestSpan("explicitOperationName2", Collections.emptyMap(), Collections.emptyList()), new TestSpanTree.TreeNode[0]), new TestSpanTree.TreeNode<TestSpan>(new TestSpan(TestDisabledAnnotatedClass.class.getName() + ".annotatedClassMethodExplicitlyTraced", Collections.emptyMap(), Collections.emptyList()), new TestSpanTree.TreeNode[0]), new TestSpanTree.TreeNode<TestSpan>(new TestSpan("explicitOperationName3", Collections.emptyMap(), Collections.emptyList()), new TestSpanTree.TreeNode[0])));
        this.assertEqualTrees(spans, expectedTree);
    }

    @Test
    @RunAsClient
    private void testNotTraced() throws InterruptedException {
        Response response = this.executeRemoteWebServiceRaw("testServices", "notTraced", Response.Status.OK);
        response.close();
        TestSpanTree spans = this.executeRemoteWebServiceTracerTree();
        TestSpanTree expectedTree = new TestSpanTree();
        this.assertEqualTrees(spans, expectedTree);
    }

    @Test
    @RunAsClient
    private void testOperationName() throws InterruptedException {
        Response response = this.executeRemoteWebServiceRaw("testServices", "operationName", Response.Status.OK);
        response.close();
        TestSpanTree spans = this.executeRemoteWebServiceTracerTree();
        TestSpanTree expectedTree = new TestSpanTree(new TestSpanTree.TreeNode<TestSpan>(new TestSpan("operationName", this.getExpectedSpanTags("server", "GET", "testServices", "operationName", null, Response.Status.OK.getStatusCode(), "jaxrs"), Collections.emptyList()), new TestSpanTree.TreeNode[0]));
        this.assertEqualTrees(spans, expectedTree);
    }

    @Test
    @RunAsClient
    private void testClassOperationName() throws InterruptedException {
        Response response = this.executeRemoteWebServiceRaw("testServicesWithOpName", "classOperationName", Response.Status.OK);
        response.close();
        TestSpanTree spans = this.executeRemoteWebServiceTracerTree();
        TestSpanTree expectedTree = new TestSpanTree(new TestSpanTree.TreeNode<TestSpan>(new TestSpan("wsOperations", this.getExpectedSpanTags("server", "GET", "testServicesWithOpName", "classOperationName", null, Response.Status.OK.getStatusCode(), "jaxrs"), Collections.emptyList()), new TestSpanTree.TreeNode<TestSpan>(new TestSpan("operationPrefix", Collections.emptyMap(), Collections.emptyList()), new TestSpanTree.TreeNode[0]), new TestSpanTree.TreeNode<TestSpan>(new TestSpan("explicitOperationName4", Collections.emptyMap(), Collections.emptyList()), new TestSpanTree.TreeNode[0])));
        this.assertEqualTrees(spans, expectedTree);
    }

    @Test
    @RunAsClient
    private void testClassAndMethodOperationName() throws InterruptedException {
        Response response = this.executeRemoteWebServiceRaw("testServicesWithOpName", "classAndMethodOperationName", Response.Status.OK);
        response.close();
        TestSpanTree spans = this.executeRemoteWebServiceTracerTree();
        TestSpanTree expectedTree = new TestSpanTree(new TestSpanTree.TreeNode<TestSpan>(new TestSpan("endpointName", this.getExpectedSpanTags("server", "GET", "testServicesWithOpName", "classAndMethodOperationName", null, Response.Status.OK.getStatusCode(), "jaxrs"), Collections.emptyList()), new TestSpanTree.TreeNode[0]));
        this.assertEqualTrees(spans, expectedTree);
    }

    @Test
    @RunAsClient
    private void testError() throws InterruptedException {
        this.assertErrorTest(this.getEndpointMethod(TestServerWebServices.class, "error"));
    }

    @Test
    @RunAsClient
    private void testException() throws InterruptedException {
        this.assertErrorTest(this.getEndpointMethod(TestServerWebServices.class, "exception"));
    }

    private void assertErrorTest(Method method) {
        String path = method.getAnnotation(Path.class).value();
        Response response = this.executeRemoteWebServiceRaw("testServices", path, Response.Status.INTERNAL_SERVER_ERROR);
        response.close();
        TestSpanTree spans = this.executeRemoteWebServiceTracerTree();
        Map<String, Object> expectedTags = this.getExpectedSpanTagsForError(path, "server");
        TestSpanTree expectedTree = new TestSpanTree(new TestSpanTree.TreeNode<TestSpan>(new TestSpan(this.getOperationName("server", "GET", TestServerWebServices.class, method), expectedTags, Collections.emptyList()), new TestSpanTree.TreeNode[0]));
        this.assertEqualTrees(spans, expectedTree);
    }

    @Test
    @RunAsClient
    private void testAnnotationException() throws InterruptedException {
        Response response = this.executeRemoteWebServiceRaw("testServices", "annotationException", Response.Status.OK);
        response.close();
        TestSpanTree spans = this.executeRemoteWebServiceTracerTree();
        HashMap<String, Object> tags = new HashMap<String, Object>();
        tags.put(Tags.ERROR.getKey(), true);
        HashMap<String, Object> logs = new HashMap<String, Object>();
        logs.put("event", Tags.ERROR.getKey());
        logs.put("error.object", new RuntimeException());
        TestSpanTree expectedTree = new TestSpanTree(new TestSpanTree.TreeNode<TestSpan>(new TestSpan(this.getOperationName("server", "GET", TestServerWebServices.class, this.getEndpointMethod(TestServerWebServices.class, "annotationException")), this.getExpectedSpanTags("server", "GET", "testServices", "annotationException", null, Response.Status.OK.getStatusCode(), "jaxrs"), Collections.emptyList()), new TestSpanTree.TreeNode<TestSpan>(new TestSpan(TestAnnotatedClass.class.getName() + ".annotatedClassMethodImplicitlyTracedWithException", tags, Arrays.asList(logs)), new TestSpanTree.TreeNode[0])));
        this.assertEqualErrorTrees(spans, expectedTree);
    }

    @Test
    @RunAsClient
    private void testNestedSpans() throws InterruptedException {
        int nestDepth = 1;
        int nestBreadth = 2;
        int uniqueId = this.getRandomNumber();
        boolean failNest = false;
        boolean async = false;
        this.testNestedSpans("nested", nestDepth, nestBreadth, uniqueId, failNest, async);
    }

    @Test
    @RunAsClient
    private void testNestedSpansWithClientFailure() throws InterruptedException {
        int nestDepth = 1;
        int nestBreadth = 2;
        int uniqueId = this.getRandomNumber();
        boolean failNest = true;
        boolean async = false;
        this.testNestedSpans("nested", nestDepth, nestBreadth, uniqueId, failNest, async);
    }

    @Test
    @RunAsClient
    private void testMultithreadedNestedSpans() throws InterruptedException, ExecutionException {
        int numberOfCalls = 100;
        int nestDepth = 1;
        int nestBreadth = 2;
        boolean failNest = false;
        boolean async = false;
        this.testMultithreadedNestedSpans("nested", numberOfCalls, nestDepth, nestBreadth, failNest, async);
    }

    @Test
    @RunAsClient
    private void testMultithreadedNestedSpansAsync() throws InterruptedException, ExecutionException {
        int numberOfCalls = 100;
        int nestDepth = 1;
        int nestBreadth = 2;
        boolean failNest = false;
        boolean async = true;
        this.testMultithreadedNestedSpans("nested", numberOfCalls, nestDepth, nestBreadth, failNest, async);
    }

    @Test
    @RunAsClient
    private void testLocalSpanHasParent() throws InterruptedException {
        Response response = this.executeRemoteWebServiceRaw("testServices", "localSpan", Response.Status.OK);
        response.close();
        TestSpanTree spans = this.executeRemoteWebServiceTracerTree();
        TestSpanTree expectedTree = new TestSpanTree(new TestSpanTree.TreeNode<TestSpan>(new TestSpan(this.getOperationName("server", "GET", TestServerWebServices.class, this.getEndpointMethod(TestServerWebServices.class, "localSpan")), this.getExpectedSpanTags("server", "GET", "testServices", "localSpan", null, Response.Status.OK.getStatusCode(), "jaxrs"), Collections.emptyList()), new TestSpanTree.TreeNode<TestSpan>(new TestSpan("localSpan", this.getExpectedLocalSpanTags(), Collections.emptyList()), new TestSpanTree.TreeNode[0])));
        this.assertEqualTrees(spans, expectedTree);
    }

    @Test
    @RunAsClient
    private void testAsyncLocalSpan() throws InterruptedException {
        Response response = this.executeRemoteWebServiceRaw("testServices", "asyncLocalSpan", Response.Status.OK);
        response.close();
        TestSpanTree spans = this.executeRemoteWebServiceTracerTree();
        TestSpanTree expectedTree = new TestSpanTree(new TestSpanTree.TreeNode<TestSpan>(new TestSpan(this.getOperationName("server", "GET", TestServerWebServices.class, this.getEndpointMethod(TestServerWebServices.class, "asyncLocalSpan")), this.getExpectedSpanTags("server", "GET", "testServices", "asyncLocalSpan", null, Response.Status.OK.getStatusCode(), "jaxrs"), Collections.emptyList()), new TestSpanTree.TreeNode<TestSpan>(new TestSpan("localSpan", this.getExpectedLocalSpanTags(), Collections.emptyList()), new TestSpanTree.TreeNode[0])));
        this.assertEqualTrees(spans, expectedTree);
    }

    private Map<String, Object> getExpectedLocalSpanTags() {
        HashMap<String, Object> tags = new HashMap<String, Object>();
        tags.put("localSpanKey", "localSpanValue");
        return tags;
    }
}

