/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.opentracing.tck.rest.client;

import java.lang.constant.Constable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.ws.rs.core.Response;
import org.eclipse.microprofile.opentracing.tck.OpenTracingBaseTests;
import org.eclipse.microprofile.opentracing.tck.application.TestServerWebServices;
import org.eclipse.microprofile.opentracing.tck.application.TestWebServicesApplication;
import org.eclipse.microprofile.opentracing.tck.rest.client.RestClientServices;
import org.eclipse.microprofile.opentracing.tck.tracer.ConsumableTree;
import org.eclipse.microprofile.opentracing.tck.tracer.TestSpan;
import org.eclipse.microprofile.opentracing.tck.tracer.TestSpanTree;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.annotations.Test;

public class OpenTracingMpRestClientTests
extends OpenTracingBaseTests {
    @Deployment
    public static WebArchive createDeployment() {
        WebArchive deployment = OpenTracingBaseTests.createDeployment();
        deployment.addPackages(true, new Package[]{OpenTracingMpRestClientTests.class.getPackage()});
        deployment.deleteClass(TestWebServicesApplication.class.getCanonicalName());
        return deployment;
    }

    @Test
    @RunAsClient
    private void testNestedSpans() {
        int nestDepth = 1;
        int nestBreadth = 2;
        int uniqueId = this.getRandomNumber();
        boolean failNest = false;
        boolean async = false;
        this.testNestedSpans("nestedMpRestClient", nestDepth, nestBreadth, uniqueId, failNest, async);
    }

    @Test
    @RunAsClient
    private void testMultithreadedNestedSpans() throws ExecutionException, InterruptedException {
        int numberOfCalls = 100;
        int nestDepth = 1;
        int nestBreadth = 2;
        boolean failNest = false;
        boolean async = false;
        this.testMultithreadedNestedSpans("nestedMpRestClient", numberOfCalls, nestDepth, nestBreadth, failNest, async);
    }

    @Test
    @RunAsClient
    private void testMultithreadedNestedSpansAsync() throws ExecutionException, InterruptedException {
        int numberOfCalls = 100;
        int nestDepth = 1;
        int nestBreadth = 2;
        boolean failNest = false;
        boolean async = true;
        this.testMultithreadedNestedSpans("nestedMpRestClient", numberOfCalls, nestDepth, nestBreadth, failNest, async);
    }

    @Test
    @RunAsClient
    private void testClientNotTraced() {
        this.testNotTraced("restClientTracingDisabled");
    }

    @Test
    @RunAsClient
    private void testMethodNotTraced() {
        this.testNotTraced("restClientMethodTracingDisabled");
    }

    private void testNotTraced(String service) {
        this.executeRemoteWebServiceRaw("mpRestClient", service, Response.Status.OK).close();
        TestSpanTree expectedTree = new TestSpanTree(new TestSpanTree.TreeNode[]{new TestSpanTree.TreeNode((Object)new TestSpan(this.getOperationName("server", "GET", TestServerWebServices.class, this.getEndpointMethod(TestServerWebServices.class, "simpleTest")), this.getExpectedSpanTags("server", "GET", "testServices", "simpleTest", null, Response.Status.OK.getStatusCode(), "jaxrs"), Collections.emptyList()), new TestSpanTree.TreeNode[0]), new TestSpanTree.TreeNode((Object)new TestSpan(this.getOperationName("server", "GET", RestClientServices.class, this.getEndpointMethod(RestClientServices.class, service)), this.getExpectedSpanTags("server", "GET", "mpRestClient", service, null, Response.Status.OK.getStatusCode(), "jaxrs"), Collections.emptyList()), new TestSpanTree.TreeNode[0])});
        TestSpanTree spans = this.executeRemoteWebServiceTracerTree();
        this.assertEqualTrees((ConsumableTree)spans, (ConsumableTree)expectedTree);
    }

    protected void executeNested(String path, int uniqueId, int nestDepth, int nestBreadth, boolean failNest, boolean async) {
        Map queryParameters = this.getNestedQueryParameters(uniqueId, nestDepth, nestBreadth, failNest, async);
        Response response = this.executeRemoteWebServiceRaw("mpRestClient", path, queryParameters, Response.Status.OK);
        response.close();
    }

    protected TestSpan getExpectedNestedServerSpan(String path, String spanKind, int uniqueId, int nestDepth, int nestBreadth, boolean failNest, boolean isFailed, boolean async) {
        HashMap<String, Constable> queryParameters = new HashMap<String, Constable>();
        queryParameters.put("data", Integer.valueOf(uniqueId));
        queryParameters.put("nestDepth", Integer.valueOf(nestDepth));
        queryParameters.put("nestBreadth", Integer.valueOf(nestBreadth));
        queryParameters.put("failNest", Boolean.valueOf(failNest));
        queryParameters.put("async", Boolean.valueOf(async));
        String operationName = this.getOperationName(spanKind, "GET", RestClientServices.class, this.getEndpointMethod(RestClientServices.class, path));
        Map expectedTags = this.getExpectedSpanTags(spanKind, "GET", "mpRestClient", path, queryParameters, Response.Status.OK.getStatusCode(), "jaxrs");
        return new TestSpan(operationName, expectedTags, Collections.emptyList());
    }
}

