/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.opentracing.tck;

import java.util.Collections;
import java.util.HashMap;
import javax.ws.rs.core.Response;
import org.eclipse.microprofile.opentracing.tck.OpenTracingBaseTests;
import org.eclipse.microprofile.opentracing.tck.application.TestClientRegistrarWebServices;
import org.eclipse.microprofile.opentracing.tck.tracer.TestSpan;
import org.eclipse.microprofile.opentracing.tck.tracer.TestSpanTree;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.annotations.Test;

public class ClientRegistrarTests
extends OpenTracingBaseTests {
    @Deployment
    public static WebArchive createDeployment() {
        return OpenTracingBaseTests.createDeployment();
    }

    @Test
    @RunAsClient
    public void testClientRegistrar() {
        this.testClientRegistrar("clientBuilder", false);
    }

    @Test
    @RunAsClient
    public void testClientRegistrarAsync() {
        this.testClientRegistrar("clientBuilder", true);
    }

    @Test
    @RunAsClient
    public void testClientRegistrarExecutor() {
        this.testClientRegistrar("clientBuilderExecutor", false);
    }

    @Test
    @RunAsClient
    public void testClientRegistrarExecutorAsync() {
        this.testClientRegistrar("clientBuilderExecutor", true);
    }

    public void testClientRegistrar(String path, boolean async) {
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        if (async) {
            queryParams.put("async", "true");
        }
        Response response = this.executeRemoteWebServiceRaw("testRegistrarServices", path, queryParams, Response.Status.OK);
        response.close();
        TestSpanTree spans = this.executeRemoteWebServiceTracerTree();
        TestSpanTree expectedTree = new TestSpanTree(new TestSpanTree.TreeNode<TestSpan>(new TestSpan(this.getOperationName("server", "GET", TestClientRegistrarWebServices.class, this.getEndpointMethod(TestClientRegistrarWebServices.class, path)), this.getExpectedSpanTags("server", "GET", "testRegistrarServices", path, queryParams, Response.Status.OK.getStatusCode(), "jaxrs"), Collections.emptyList()), new TestSpanTree.TreeNode<TestSpan>(new TestSpan(this.getOperationName("client", "GET", TestClientRegistrarWebServices.class, this.getEndpointMethod(TestClientRegistrarWebServices.class, "ok")), this.getExpectedSpanTags("client", "GET", "testRegistrarServices", "ok", null, Response.Status.OK.getStatusCode(), "jaxrs"), Collections.emptyList()), new TestSpanTree.TreeNode<TestSpan>(new TestSpan(this.getOperationName("server", "GET", TestClientRegistrarWebServices.class, this.getEndpointMethod(TestClientRegistrarWebServices.class, "ok")), this.getExpectedSpanTags("server", "GET", "testRegistrarServices", "ok", null, Response.Status.OK.getStatusCode(), "jaxrs"), Collections.emptyList()), new TestSpanTree.TreeNode[0]))));
        this.assertEqualTrees(spans, expectedTree);
    }
}

