/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.openapi.apps.petstore.data;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.microprofile.openapi.apps.petstore.model.Order;

public class StoreData {
    private static List<Order> orders = new ArrayList<Order>();

    public Order findOrderById(long orderId) {
        for (Order order : orders) {
            if (order.getId() != orderId) continue;
            return order;
        }
        return null;
    }

    public Order placeOrder(Order order) {
        if (orders.size() > 0) {
            for (int i = orders.size() - 1; i >= 0; --i) {
                if (orders.get(i).getId() != order.getId()) continue;
                orders.remove(i);
            }
        }
        orders.add(order);
        return order;
    }

    public boolean deleteOrder(long orderId) {
        if (orders.size() > 0) {
            for (int i = orders.size() - 1; i >= 0; --i) {
                if (orders.get(i).getId() != orderId) continue;
                orders.remove(i);
                return true;
            }
        }
        return false;
    }

    private static Order createOrder(long id, long petId, int quantity, Date shipDate, String status) {
        Order order = new Order();
        order.setId(id);
        order.setPetId(petId);
        order.setQuantity(quantity);
        order.setShipDate(shipDate);
        order.setStatus(status);
        return order;
    }

    static {
        orders.add(StoreData.createOrder(1L, 1L, 2, new Date(), "placed"));
        orders.add(StoreData.createOrder(2L, 1L, 2, new Date(), "delivered"));
        orders.add(StoreData.createOrder(3L, 2L, 2, new Date(), "placed"));
        orders.add(StoreData.createOrder(4L, 2L, 2, new Date(), "delivered"));
        orders.add(StoreData.createOrder(5L, 3L, 2, new Date(), "placed"));
        orders.add(StoreData.createOrder(6L, 3L, 2, new Date(), "placed"));
        orders.add(StoreData.createOrder(7L, 3L, 2, new Date(), "placed"));
        orders.add(StoreData.createOrder(8L, 3L, 2, new Date(), "placed"));
        orders.add(StoreData.createOrder(9L, 3L, 2, new Date(), "placed"));
        orders.add(StoreData.createOrder(10L, 3L, 2, new Date(), "placed"));
    }
}

