/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.metrics.test;

import io.restassured.RestAssured;
import io.restassured.builder.ResponseBuilder;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import jakarta.inject.Inject;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.microprofile.metrics.test.MetricAppBean2;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.junit.InSequence;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class ReusedMetricsTest {
    private static final String OPENMETRICS_APP_LABEL_REGEX = "mp_app=\"[-/A-Za-z0-9]+\"";
    private static final String TEXT_PLAIN = "text/plain";
    private static final String DEFAULT_PROTOCOL = "http";
    private static final String DEFAULT_HOST = "localhost";
    private static final int DEFAULT_PORT = 8080;
    @Inject
    private MetricAppBean2 metricAppBean;

    private static String filterOutAppLabelPromMetrics(String responseBody) {
        return responseBody.replaceAll(OPENMETRICS_APP_LABEL_REGEX, "").replaceAll("\\{,", "{").replaceAll(",\\}", "}");
    }

    @BeforeClass
    public static void setup() throws MalformedURLException {
        String serverUrl = System.getProperty("test.url");
        String protocol = DEFAULT_PROTOCOL;
        String host = DEFAULT_HOST;
        int port = 8080;
        if (serverUrl != null) {
            URL url = new URL(serverUrl);
            protocol = url.getProtocol();
            host = url.getHost();
            port = url.getPort() == -1 ? 8080 : url.getPort();
        }
        RestAssured.baseURI = protocol + "://" + host;
        RestAssured.port = port;
        String userName = System.getProperty("test.user");
        String password = System.getProperty("test.pwd");
        if (userName != null && password != null) {
            RestAssured.authentication = RestAssured.basic((String)userName, (String)password);
            RestAssured.useRelaxedHTTPSValidation();
        }
    }

    @Deployment
    public static WebArchive createDeployment() {
        WebArchive jar = (WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addClass(MetricAppBean2.class)).addAsWebInfResource("META-INF/beans.xml", "beans.xml");
        return jar;
    }

    @Test
    @InSequence(value=1)
    public void setA() {
        this.metricAppBean.countMeA();
        this.metricAppBean.timeMeA();
    }

    @Test
    @RunAsClient
    @InSequence(value=2)
    public void testSharedCounter() {
        Response resp = (Response)RestAssured.given().header("Accept", (Object)TEXT_PLAIN, new Object[0]).get("/metrics?scope=application", new Object[0]);
        ResponseBuilder responseBuilder = new ResponseBuilder();
        responseBuilder.clone(resp);
        responseBuilder.setBody(ReusedMetricsTest.filterOutAppLabelPromMetrics(resp.getBody().asString()));
        resp = responseBuilder.build();
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)resp.then()).statusCode(200)).and()).body(CoreMatchers.containsString((String)"# TYPE countMe2_total counter"), new Matcher[0])).body(CoreMatchers.containsString((String)"countMe2_total{mp_scope=\"application\",tier=\"integration\"} 1"), new Matcher[0])).body(CoreMatchers.containsString((String)"# TYPE timeMe2_seconds summary"), new Matcher[0])).body(CoreMatchers.containsString((String)"timeMe2_seconds_count{mp_scope=\"application\",tier=\"integration\"} 1"), new Matcher[0]);
    }

    @Test
    @InSequence(value=3)
    public void setB() {
        this.metricAppBean.countMeB();
        this.metricAppBean.timeMeB();
    }

    @Test
    @RunAsClient
    @InSequence(value=4)
    public void testSharedCounterAgain() {
        Response resp = (Response)RestAssured.given().header("Accept", (Object)TEXT_PLAIN, new Object[0]).get("/metrics?scope=application", new Object[0]);
        ResponseBuilder responseBuilder = new ResponseBuilder();
        responseBuilder.clone(resp);
        responseBuilder.setBody(ReusedMetricsTest.filterOutAppLabelPromMetrics(resp.getBody().asString()));
        resp = responseBuilder.build();
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)resp.then()).statusCode(200)).and()).body(CoreMatchers.containsString((String)"# TYPE countMe2_total counter"), new Matcher[0])).body(CoreMatchers.containsString((String)"countMe2_total{mp_scope=\"application\",tier=\"integration\"} 2"), new Matcher[0])).body(CoreMatchers.containsString((String)"# TYPE timeMe2_seconds summary"), new Matcher[0])).body(CoreMatchers.containsString((String)"timeMe2_seconds_count{mp_scope=\"application\",tier=\"integration\"} 2"), new Matcher[0]);
    }
}

