/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.lra.tck.participant.activity;

import java.io.Serializable;
import java.net.URI;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.microprofile.lra.annotation.ParticipantStatus;

public class Activity
implements Serializable {
    private static final long serialVersionUID = 1L;
    private URI lraId;
    private URI recoveryUri;
    private String statusUrl;
    private ParticipantStatus status;
    private String endData;
    private final AtomicInteger acceptedCount = new AtomicInteger(0);

    public Activity(URI lraId) {
        this.setLraId(lraId);
    }

    public URI getLraId() {
        return this.lraId;
    }

    public Activity setLraId(URI lraId) {
        this.lraId = lraId;
        return this;
    }

    public URI getRecoveryUri() {
        return this.recoveryUri;
    }

    public Activity setRecoveryUri(URI recoveryUri) {
        this.recoveryUri = recoveryUri;
        return this;
    }

    public String getStatusUrl() {
        return this.statusUrl;
    }

    public Activity setStatusUrl(String statusUrl) {
        this.statusUrl = statusUrl;
        return this;
    }

    public ParticipantStatus getStatus() {
        return this.status;
    }

    public Activity setStatus(ParticipantStatus status) {
        this.status = status;
        return this;
    }

    public String toString() {
        return "Activity{lraId='" + this.getLraId() + '\'' + ", recoveryUri='" + this.getRecoveryUri() + '\'' + ", statusUrl='" + this.getStatusUrl() + '\'' + ", status=" + this.getStatus() + ", endData='" + this.getEndData() + '\'' + '}';
    }

    public int getAndDecrementAcceptCount() {
        return this.getAcceptedCount().getAndDecrement();
    }

    public String getEndData() {
        return this.endData;
    }

    public Activity setEndData(String endData) {
        this.endData = endData;
        return this;
    }

    public AtomicInteger getAcceptedCount() {
        return this.acceptedCount;
    }

    public Activity setAcceptedCount(int acceptedCount) {
        this.acceptedCount.set(acceptedCount);
        return this;
    }
}

