/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.lra.tck.participant.api;

import java.net.URI;
import javax.enterprise.context.ApplicationScoped;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@ApplicationScoped
@Path(value="nolraresource")
public class NoLRAResource {
    public static final String NO_LRA_RESOURCE_PATH = "nolraresource";
    public static final String NON_TRANSACTIONAL_WORK_PATH = "work";
    @Context
    private UriInfo context;

    @PUT
    @Path(value="work")
    public Response work2(@HeaderParam(value="Long-Running-Action") URI lraId) {
        if (lraId != null) {
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)"Unexpected LRA context").build();
        }
        WebTarget resourcePath = ClientBuilder.newClient().target(this.context.getBaseUri()).path("lraresource").path("/mandatory");
        Response response = resourcePath.request().put(Entity.text((Object)""));
        String id = this.checkStatusAndClose(response, Response.Status.OK.getStatusCode(), true, resourcePath);
        if (id == null) {
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)"LRA context was not propagated").build();
        }
        return Response.ok((Object)id).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String checkStatusAndClose(Response response, int expected, boolean readEntity, WebTarget webTarget) {
        try {
            if (expected != -1 && response.getStatus() != expected) {
                if (webTarget != null) {
                    throw new WebApplicationException(String.format("%s: expected status %d got %d", webTarget.getUri().toString(), expected, response.getStatus()), response);
                }
                throw new WebApplicationException(response);
            }
            if (readEntity) {
                String string = (String)response.readEntity(String.class);
                return string;
            }
        }
        finally {
            response.close();
        }
        return null;
    }
}

