/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.lra.tck;

import java.net.URI;
import javax.inject.Inject;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.eclipse.microprofile.lra.tck.TckTestBase;
import org.eclipse.microprofile.lra.tck.participant.api.LRAUnknownStatusResource;
import org.eclipse.microprofile.lra.tck.participant.api.Scenario;
import org.eclipse.microprofile.lra.tck.service.LRAMetricAssertions;
import org.eclipse.microprofile.lra.tck.service.LRATestService;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class TckUnknownStatusTests
extends TckTestBase {
    @Inject
    private LRAMetricAssertions lraMetric;
    @Inject
    private LRATestService lraTestService;

    @Deployment(name="tckunkownstatus")
    public static WebArchive deploy() {
        return TckUnknownStatusTests.deploy(TckUnknownStatusTests.class.getSimpleName().toLowerCase());
    }

    @Override
    @Before
    public void before() {
        super.before();
    }

    @Test
    public void compensate_retry() throws WebApplicationException {
        String lraIdString = this.invoke(Scenario.COMPENSATE_RETRY);
        URI lraId = URI.create(lraIdString);
        this.lraTestService.waitForRecovery(lraId);
        this.lraMetric.assertCompensatedEquals("Number of calls to @Compensate incorrect", 1, lraId, LRAUnknownStatusResource.class);
        this.lraMetric.assertStatus("Expect @Status was called", lraId, LRAUnknownStatusResource.class);
        this.lraMetric.assertAfterLRA("Expect @AfterLRA was called", lraId, LRAUnknownStatusResource.class);
        this.lraMetric.assertCancelled("Expect Cancel was called", lraId, LRAUnknownStatusResource.class);
    }

    @Test
    public void complete_retry() throws WebApplicationException {
        String lraIdString = this.invoke(Scenario.COMPLETE_RETRY);
        URI lraId = URI.create(lraIdString);
        this.lraTestService.waitForRecovery(lraId);
        this.lraMetric.assertCompletedEquals("Number of calls to @Complete incorrect", 1, lraId, LRAUnknownStatusResource.class);
        this.lraMetric.assertStatus("Expect @Status was called", lraId, LRAUnknownStatusResource.class);
        this.lraMetric.assertAfterLRA("Expect @AfterLRA was called", lraId, LRAUnknownStatusResource.class);
        this.lraMetric.assertClosed("Expect Close was called", lraId, LRAUnknownStatusResource.class);
    }

    private String invoke(Scenario scenario) {
        WebTarget resourcePath = this.tckSuiteTarget.path("lraUnknownStatusController").path("work").queryParam("scenario", new Object[]{scenario.name()});
        Response response = resourcePath.request().put(Entity.text((Object)""));
        return this.checkStatusReadAndCloseResponse(Response.Status.fromStatusCode((int)scenario.getPathResponseCode()), response, resourcePath);
    }
}

