/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.lra.tck;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.eclipse.microprofile.lra.tck.TckTestBase;
import org.eclipse.microprofile.lra.tck.participant.api.RecoveryResource;
import org.eclipse.microprofile.lra.tck.service.LRAMetricType;
import org.eclipse.microprofile.lra.tck.service.LRATestService;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployer;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
@RunAsClient
public class TckRecoveryTests {
    private static final Logger LOG = Logger.getLogger(TckRecoveryTests.class.getName());
    private static final String DEPLOYMENT_NAME = "tck-recovery";
    private static final Logger LOGGER = Logger.getLogger(TckRecoveryTests.class.getName());
    @ArquillianResource
    private Deployer deployer;
    private LRATestService lraTestService;
    private Client deploymentClient;
    private WebTarget deploymentTarget;
    @Rule
    public TestName testName = new TestName();

    @Before
    public void before() {
        LOGGER.info("Running test: " + this.testName.getMethodName());
        this.deployer.deploy(DEPLOYMENT_NAME);
    }

    @After
    public void after() {
        try {
            this.deployer.undeploy(DEPLOYMENT_NAME);
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Cannot undeploy the deployment tck-recovery at the end of the test " + this.testName, e);
        }
        this.deploymentClient.close();
        this.lraTestService.stop();
    }

    @Deployment(name="tck-recovery", managed=false)
    public static WebArchive deploy() {
        return TckTestBase.deploy(DEPLOYMENT_NAME);
    }

    @Test
    public void testCancelWhenParticipantIsRestarted(@ArquillianResource URL deploymentURL) {
        this.clientServiceSetup(deploymentURL);
        Response response = this.deploymentTarget.path("recovery-resource").path("required").request().put(Entity.text((Object)""));
        Assert.assertEquals((long)200L, (long)response.getStatus());
        URI lra = URI.create((String)response.readEntity(String.class));
        this.deployer.undeploy(DEPLOYMENT_NAME);
        this.deployer.deploy(DEPLOYMENT_NAME);
        this.lraTestService.getLRAClient().cancelLRA(lra);
        this.lraTestService.waitForCallbacks(lra);
        this.assertMetricCallbackCalled(LRAMetricType.Compensated, lra);
        this.assertMetricCallbackCalled(LRAMetricType.Cancelled, lra);
    }

    @Test
    public void testCancelWhenParticipantIsUnavailable(@ArquillianResource URL deploymentURL) {
        this.clientServiceSetup(deploymentURL);
        Response response = this.deploymentTarget.path("recovery-resource").path("required-timeout").request().put(Entity.text((Object)""));
        Assert.assertEquals((long)200L, (long)response.getStatus());
        URI lra = URI.create((String)response.readEntity(String.class));
        this.deployer.undeploy(DEPLOYMENT_NAME);
        try {
            Thread.sleep(this.adjustTimeoutByDefaultFactor(500L));
        }
        catch (InterruptedException e) {
            LOG.log(Level.SEVERE, "Sleep LRA timeout interrupted", e);
            Assert.fail((String)("Sleeping LRA timeout 500 was interrupted: " + e.getMessage()));
        }
        this.lraTestService.waitForCallbacks(lra);
        this.deployer.deploy(DEPLOYMENT_NAME);
        this.lraTestService.waitForRecovery(lra);
        this.lraTestService.waitForCallbacks(lra);
        this.assertMetricCallbackCalled(LRAMetricType.Compensated, lra);
        this.assertMetricCallbackCalled(LRAMetricType.Cancelled, lra);
    }

    private void assertMetricCallbackCalled(LRAMetricType metricType, URI lra) {
        Response responseMetric = this.deploymentTarget.path("lra-tck-metric").path("metric").queryParam("metricType", new Object[]{metricType}).queryParam("lraId", new Object[]{lra}).queryParam("participantName", new Object[]{RecoveryResource.class.getName()}).request().get();
        Assert.assertEquals((String)("Expect the metric REST call to " + responseMetric.getLocation() + " to succeed"), (long)200L, (long)responseMetric.getStatus());
        int metricNumber = (Integer)responseMetric.readEntity(Integer.class);
        MatcherAssert.assertThat((String)("Expecting the metric " + (Object)((Object)metricType) + " callback was called"), (Object)metricNumber, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1)));
    }

    private long adjustTimeoutByDefaultFactor(long timeout) {
        String timeoutFactor = System.getProperty("lra.tck.timeout.factor", "1.0");
        return (long)Math.ceil((double)timeout * Double.parseDouble(timeoutFactor));
    }

    private void clientServiceSetup(URL deploymentURL) {
        try {
            this.deploymentClient = ClientBuilder.newClient();
            this.deploymentTarget = this.deploymentClient.target(deploymentURL.toURI());
            this.lraTestService = new LRATestService();
            this.lraTestService.start(deploymentURL);
        }
        catch (URISyntaxException use) {
            throw new IllegalStateException("Cannot create URI from deployment URL " + deploymentURL, use);
        }
    }
}

