/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck.retry.clientserver;

import jakarta.enterprise.context.RequestScoped;
import java.io.IOException;
import java.sql.Connection;
import org.eclipse.microprofile.fault.tolerance.tck.util.TestException;
import org.eclipse.microprofile.faulttolerance.Retry;

@RequestScoped
@Retry(retryOn={TestException.class}, maxRetries=3)
public class RetryClassLevelClientRetryOn {
    private int counterForInvokingConnenectionService;
    private int counterForInvokingWritingService;

    public Connection serviceA() {
        return this.connectionService();
    }

    private Connection connectionService() {
        ++this.counterForInvokingConnenectionService;
        throw new TestException("Connection failed");
    }

    public int getRetryCountForConnectionService() {
        return this.counterForInvokingConnenectionService;
    }

    @Retry(retryOn={IOException.class})
    public void serviceB() {
        this.writingService();
    }

    private void writingService() {
        ++this.counterForInvokingWritingService;
        try {
            Thread.sleep(100L);
            throw new TestException("WritingService failed");
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return;
        }
    }

    public int getRetryCountForWritingService() {
        return this.counterForInvokingWritingService;
    }
}

