/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck;

import jakarta.inject.Inject;
import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.microprofile.fault.tolerance.tck.asynctimeout.clientserver.AsyncClassLevelTimeoutClient;
import org.eclipse.microprofile.fault.tolerance.tck.asynctimeout.clientserver.AsyncTimeoutClient;
import org.eclipse.microprofile.fault.tolerance.tck.config.ConfigAnnotationAsset;
import org.eclipse.microprofile.fault.tolerance.tck.util.Connection;
import org.eclipse.microprofile.fault.tolerance.tck.util.TCKConfig;
import org.eclipse.microprofile.faulttolerance.Timeout;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.Test;

public class AsyncTimeoutTest
extends Arquillian {
    @Inject
    private AsyncTimeoutClient clientForAsyncTimeout;
    @Inject
    private AsyncClassLevelTimeoutClient clientForClassLevelAsyncTimeout;
    private static final Duration TEST_FUTURE_THRESHOLD = TCKConfig.getConfig().getTimeoutInDuration(2000);
    private static final Duration TEST_TIMEOUT_SERVICEA = TCKConfig.getConfig().getTimeoutInDuration(2000);
    private static final Duration TEST_TIMEOUT_SERVICEB = TCKConfig.getConfig().getTimeoutInDuration(2000);
    private static final Duration TEST_TIME_UNIT = TCKConfig.getConfig().getTimeoutInDuration(1000);

    @Deployment
    public static WebArchive deploy() {
        ConfigAnnotationAsset config = new ConfigAnnotationAsset().setValue(AsyncTimeoutClient.class, "serviceA", Timeout.class, String.valueOf(TEST_TIMEOUT_SERVICEA.toMillis())).setValue(AsyncTimeoutClient.class, "serviceB", Timeout.class, String.valueOf(TEST_TIMEOUT_SERVICEB.toMillis())).setValue(AsyncClassLevelTimeoutClient.class, null, Timeout.class, TCKConfig.getConfig().getTimeoutInStr(2000L));
        JavaArchive testJar = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"ftAsyncTimeout.jar")).addClasses(new Class[]{AsyncTimeoutClient.class, AsyncClassLevelTimeoutClient.class, Connection.class})).addAsManifestResource((Asset)config, "microprofile-config.properties")).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml")).as(JavaArchive.class);
        WebArchive war = (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"ftAsyncTimeout.war")).addAsLibrary((Archive)testJar);
        return war;
    }

    @Test
    public void testAsyncTimeout() {
        long start = System.nanoTime();
        Future<Connection> future = null;
        try {
            future = this.clientForAsyncTimeout.serviceA();
        }
        catch (InterruptedException e1) {
            throw new AssertionError((Object)"testAsyncTimeout: unexpected InterruptedException calling serviceA");
        }
        long end = System.nanoTime();
        Duration duration = Duration.ofNanos(end - start);
        MatcherAssert.assertThat((String)"Method did not return quickly enough", (Object)duration, (Matcher)Matchers.lessThan((Comparable)TEST_FUTURE_THRESHOLD));
        if (future.isDone()) {
            throw new AssertionError((Object)"testAsyncTimeout: Future completed too fast");
        }
        try {
            future.get(TEST_TIMEOUT_SERVICEA.plus(TEST_TIME_UNIT).toMillis(), TimeUnit.MILLISECONDS);
            throw new AssertionError((Object)"testAsyncTimeout: Future not interrupted");
        }
        catch (ExecutionException e) {
            Assert.assertSame(e.getCause().getClass(), org.eclipse.microprofile.faulttolerance.exceptions.TimeoutException.class, (String)"Should be a wrapped TimeoutException");
        }
        catch (InterruptedException e) {
            throw new AssertionError("testAsyncTimeout: unexpected InterruptedException on future.get()", e);
        }
        catch (TimeoutException e) {
            throw new AssertionError("testAsyncTimeout: unexpected TimeoutException on future.get()", e);
        }
        end = System.nanoTime();
        duration = Duration.ofNanos(end - start);
        MatcherAssert.assertThat((String)"the service duration was less than the configured timeout", (Object)duration, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)TEST_TIMEOUT_SERVICEA));
    }

    @Test
    public void testAsyncNoTimeout() {
        long start = System.nanoTime();
        Future<Connection> future = null;
        try {
            future = this.clientForAsyncTimeout.serviceB();
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)"testAsyncNoTimeout: unexpected InterruptedException calling serviceB");
        }
        long end = System.nanoTime();
        Duration duration = Duration.ofNanos(end - start);
        MatcherAssert.assertThat((String)"Method did not return quickly enough", (Object)duration, (Matcher)Matchers.lessThan((Comparable)TEST_FUTURE_THRESHOLD));
        if (future.isDone()) {
            throw new AssertionError((Object)"testAsyncNoTimeout: Future completed too fast");
        }
        try {
            Connection connection = future.get(TEST_TIME_UNIT.toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (Exception t) {
            Assert.fail((String)"serviceB should not throw an Exception in testAsyncNoTimeout");
        }
    }

    @Test
    public void testAsyncClassLevelTimeout() {
        long start = System.nanoTime();
        Future<Connection> future = null;
        try {
            future = this.clientForClassLevelAsyncTimeout.serviceA();
        }
        catch (InterruptedException e1) {
            throw new AssertionError((Object)"testAsyncClassLevelTimeout: unexpected InterruptedException calling serviceA");
        }
        long end = System.nanoTime();
        Duration duration = Duration.ofNanos(end - start);
        MatcherAssert.assertThat((String)"Method did not return quickly enough", (Object)duration, (Matcher)Matchers.lessThan((Comparable)TEST_FUTURE_THRESHOLD));
        if (future.isDone()) {
            throw new AssertionError((Object)"testAsyncClassLevelTimeout: Future completed too fast");
        }
        try {
            future.get(TEST_TIMEOUT_SERVICEA.plus(TEST_TIME_UNIT).toMillis(), TimeUnit.MILLISECONDS);
            throw new AssertionError((Object)"testAsyncClassLevelTimeout: Future not interrupted");
        }
        catch (ExecutionException e) {
            Assert.assertSame(e.getCause().getClass(), org.eclipse.microprofile.faulttolerance.exceptions.TimeoutException.class, (String)"Should be a wrapped TimeoutException");
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)"testAsyncClassLevelTimeout: unexpected InterruptedException on future.get()");
        }
        catch (TimeoutException e) {
            throw new AssertionError((Object)"testAsyncClassLevelTimeout: unexpected TimeoutException on future.get()");
        }
        end = System.nanoTime();
        duration = Duration.ofNanos(end - start);
        MatcherAssert.assertThat((String)"the service duration was less than the configured timeout", (Object)duration, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)TEST_TIMEOUT_SERVICEA));
    }
}

