/*
 *******************************************************************************
 * Copyright (c) 2020 Contributors to the Eclipse Foundation
 *
 * See the NOTICE file(s) distributed with this work for additional
 * information regarding copyright ownership.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * You may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *******************************************************************************/

package org.eclipse.microprofile.fault.tolerance.tck.config;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;

import org.eclipse.microprofile.fault.tolerance.tck.util.Barrier;
import org.eclipse.microprofile.faulttolerance.Asynchronous;
import org.eclipse.microprofile.faulttolerance.Bulkhead;

import jakarta.enterprise.context.ApplicationScoped;

/**
 * A suite of test methods to test the parameters of bulkhead
 */
@ApplicationScoped
public class BulkheadConfigBean {

    @Bulkhead(value = 5)
    public void serviceValue(Barrier barrier) {
        barrier.await();
    }

    @Bulkhead(value = 1, waitingTaskQueue = 5)
    @Asynchronous
    public Future<Void> serviceWaitingTaskQueue(Barrier barrier) {
        barrier.await();
        return CompletableFuture.completedFuture(null);
    }

}
