/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck.circuitbreaker.lifecycle;

import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.microprofile.fault.tolerance.tck.circuitbreaker.lifecycle.BaseCircuitBreakerOnClass;
import org.eclipse.microprofile.fault.tolerance.tck.circuitbreaker.lifecycle.BaseCircuitBreakerOnClassAndMethod;
import org.eclipse.microprofile.fault.tolerance.tck.circuitbreaker.lifecycle.BaseCircuitBreakerOnMethod;
import org.eclipse.microprofile.fault.tolerance.tck.circuitbreaker.lifecycle.CircuitBreakerLifecycleService;
import org.eclipse.microprofile.fault.tolerance.tck.circuitbreaker.lifecycle.CircuitBreakerLifecycleService1;
import org.eclipse.microprofile.fault.tolerance.tck.circuitbreaker.lifecycle.CircuitBreakerLifecycleService2;
import org.eclipse.microprofile.fault.tolerance.tck.circuitbreaker.lifecycle.DerivedCircuitBreakerOnClassAndMethodNoAnnotationOnOverriddenMethod;
import org.eclipse.microprofile.fault.tolerance.tck.circuitbreaker.lifecycle.DerivedCircuitBreakerOnClassAndMethodNoRedefinition;
import org.eclipse.microprofile.fault.tolerance.tck.circuitbreaker.lifecycle.DerivedCircuitBreakerOnClassAndMethodOverrideOnClass;
import org.eclipse.microprofile.fault.tolerance.tck.circuitbreaker.lifecycle.DerivedCircuitBreakerOnClassAndMethodOverrideOnClassWithOverriddenMethod;
import org.eclipse.microprofile.fault.tolerance.tck.circuitbreaker.lifecycle.DerivedCircuitBreakerOnClassAndMethodOverrideOnMethod;
import org.eclipse.microprofile.fault.tolerance.tck.circuitbreaker.lifecycle.DerivedCircuitBreakerOnClassNoAnnotationOnOverriddenMethod;
import org.eclipse.microprofile.fault.tolerance.tck.circuitbreaker.lifecycle.DerivedCircuitBreakerOnClassNoRedefinition;
import org.eclipse.microprofile.fault.tolerance.tck.circuitbreaker.lifecycle.DerivedCircuitBreakerOnClassOverrideOnClass;
import org.eclipse.microprofile.fault.tolerance.tck.circuitbreaker.lifecycle.DerivedCircuitBreakerOnClassOverrideOnClassWithOverriddenMethod;
import org.eclipse.microprofile.fault.tolerance.tck.circuitbreaker.lifecycle.DerivedCircuitBreakerOnClassOverrideOnMethod;
import org.eclipse.microprofile.fault.tolerance.tck.circuitbreaker.lifecycle.DerivedCircuitBreakerOnMethodNoAnnotationOnOverriddenMethod;
import org.eclipse.microprofile.fault.tolerance.tck.circuitbreaker.lifecycle.DerivedCircuitBreakerOnMethodNoRedefinition;
import org.eclipse.microprofile.fault.tolerance.tck.circuitbreaker.lifecycle.DerivedCircuitBreakerOnMethodOverrideOnClass;
import org.eclipse.microprofile.fault.tolerance.tck.circuitbreaker.lifecycle.DerivedCircuitBreakerOnMethodOverrideOnClassWithOverriddenMethod;
import org.eclipse.microprofile.fault.tolerance.tck.circuitbreaker.lifecycle.DerivedCircuitBreakerOnMethodOverrideOnMethod;
import org.eclipse.microprofile.fault.tolerance.tck.circuitbreaker.lifecycle.MutlipleMethodsCircuitBreakerLifecycleService;
import org.eclipse.microprofile.faulttolerance.exceptions.CircuitBreakerOpenException;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.Test;

public class CircuitBreakerLifecycleTest
extends Arquillian {
    @Inject
    private Instance<Object> beans;
    @Inject
    private Instance<CircuitBreakerLifecycleService1> service1;
    @Inject
    private Instance<CircuitBreakerLifecycleService2> service2;
    @Inject
    private Instance<MutlipleMethodsCircuitBreakerLifecycleService> multipleMethodsService;

    @Deployment
    public static WebArchive deploy() {
        JavaArchive testJar = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"ftCircuitBreakerLifecycle.jar")).addPackage(CircuitBreakerLifecycleService.class.getPackage())).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml")).as(JavaArchive.class);
        return (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"ftCircuitBreakerLifecycle.war")).addAsLibrary((Archive)testJar);
    }

    @Test
    public void circuitBreakerOnClass() {
        this.invokeService(BaseCircuitBreakerOnClass.class, 8);
    }

    @Test
    public void circuitBreakerOnClassOverrideOnClass() {
        this.invokeService(DerivedCircuitBreakerOnClassOverrideOnClass.class, 4);
    }

    @Test
    public void circuitBreakerOnClassOverrideOnClassWithOverriddenMethod() {
        this.invokeService(DerivedCircuitBreakerOnClassOverrideOnClassWithOverriddenMethod.class, 4);
    }

    @Test
    public void circuitBreakerOnClassOverrideOnMethod() {
        this.invokeService(DerivedCircuitBreakerOnClassOverrideOnMethod.class, 4);
    }

    @Test
    public void circuitBreakerOnClassMissingOnOverriddenMethod() {
        this.invokeService(DerivedCircuitBreakerOnClassNoAnnotationOnOverriddenMethod.class, 8);
    }

    @Test
    public void circuitBreakerOnClassNoRedefinition() {
        this.invokeService(DerivedCircuitBreakerOnClassNoRedefinition.class, 8);
    }

    @Test
    public void circuitBreakerOnMethod() {
        this.invokeService(BaseCircuitBreakerOnMethod.class, 8);
    }

    @Test
    public void circuitBreakerOnMethodOverrideOnClass() {
        this.invokeService(DerivedCircuitBreakerOnMethodOverrideOnClass.class, 8);
    }

    @Test
    public void circuitBreakerOnMethodOverrideOnClassWithOverriddenMethod() {
        this.invokeService(DerivedCircuitBreakerOnMethodOverrideOnClassWithOverriddenMethod.class, 4);
    }

    @Test
    public void circuitBreakerOnMethodOverrideOnMethod() {
        this.invokeService(DerivedCircuitBreakerOnMethodOverrideOnMethod.class, 4);
    }

    @Test
    public void circuitBreakerOnMethodMissingOnOverriddenMethod() {
        this.invokeService(DerivedCircuitBreakerOnMethodNoAnnotationOnOverriddenMethod.class, 100);
    }

    @Test
    public void circuitBreakerOnMethodNoRedefinition() {
        this.invokeService(DerivedCircuitBreakerOnMethodNoRedefinition.class, 8);
    }

    @Test
    public void circuitBreakerOnClassAndMethod() {
        this.invokeService(BaseCircuitBreakerOnClassAndMethod.class, 8);
    }

    @Test
    public void circuitBreakerOnClassAndMethodOverrideOnClass() {
        this.invokeService(DerivedCircuitBreakerOnClassAndMethodOverrideOnClass.class, 8);
    }

    @Test
    public void circuitBreakerOnClassAndMethodOverrideOnClassWithOverriddenMethod() {
        this.invokeService(DerivedCircuitBreakerOnClassAndMethodOverrideOnClassWithOverriddenMethod.class, 4);
    }

    @Test
    public void circuitBreakerOnClassAndMethodOverrideOnMethod() {
        this.invokeService(DerivedCircuitBreakerOnClassAndMethodOverrideOnMethod.class, 4);
    }

    @Test
    public void circuitBreakerOnClassAndMethodMissingOnOverriddenMethod() {
        this.invokeService(DerivedCircuitBreakerOnClassAndMethodNoAnnotationOnOverriddenMethod.class, 16);
    }

    @Test
    public void circuitBreakerOnClassAndMethodNoRedefinition() {
        this.invokeService(DerivedCircuitBreakerOnClassAndMethodNoRedefinition.class, 8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private <T extends CircuitBreakerLifecycleService> void invokeService(Class<T> clazz, int expectedCallsNotPrevented) {
        Instance serviceProvider = this.beans.select(clazz, new Annotation[0]);
        int servicesCount = expectedCallsNotPrevented / 2;
        ArrayList<Object> services = new ArrayList<Object>(servicesCount);
        for (int i = 0; i < servicesCount; ++i) {
            services.add(serviceProvider.get());
        }
        try {
            void var7_9;
            HashSet<Integer> instanceIds = new HashSet<Integer>();
            boolean bl = false;
            while (var7_9 < servicesCount) {
                instanceIds.add(((CircuitBreakerLifecycleService)services.get((int)var7_9)).instanceId());
                ++var7_9;
            }
            Assert.assertEquals((int)instanceIds.size(), (int)servicesCount);
            boolean bl2 = false;
            for (int i = 0; i < expectedCallsNotPrevented; ++i) {
                void var7_11;
                CircuitBreakerLifecycleService service = (CircuitBreakerLifecycleService)services.get((int)var7_11);
                Assert.assertThrows(IOException.class, service::service);
                var7_11 = (var7_11 + true) % servicesCount;
            }
            Class expectedException = expectedCallsNotPrevented < 100 ? CircuitBreakerOpenException.class : IOException.class;
            for (CircuitBreakerLifecycleService circuitBreakerLifecycleService : services) {
                Assert.assertThrows(expectedException, circuitBreakerLifecycleService::service);
            }
        }
        finally {
            for (CircuitBreakerLifecycleService circuitBreakerLifecycleService : services) {
                serviceProvider.destroy((Object)circuitBreakerLifecycleService);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void noSharingBetweenClasses() {
        CircuitBreakerLifecycleService1 service1a = (CircuitBreakerLifecycleService1)this.service1.get();
        CircuitBreakerLifecycleService1 service1b = (CircuitBreakerLifecycleService1)this.service1.get();
        CircuitBreakerLifecycleService2 service2a = (CircuitBreakerLifecycleService2)this.service2.get();
        CircuitBreakerLifecycleService2 service2b = (CircuitBreakerLifecycleService2)this.service2.get();
        try {
            for (int i = 0; i < 4; ++i) {
                Assert.assertThrows(IOException.class, service1a::service);
                Assert.assertThrows(IOException.class, service2a::service);
                Assert.assertThrows(IOException.class, service1b::service);
                Assert.assertThrows(IOException.class, service2b::service);
            }
            Assert.assertThrows(CircuitBreakerOpenException.class, service1a::service);
            Assert.assertThrows(CircuitBreakerOpenException.class, service2a::service);
            Assert.assertThrows(CircuitBreakerOpenException.class, service1b::service);
            Assert.assertThrows(CircuitBreakerOpenException.class, service2b::service);
        }
        finally {
            this.service1.destroy((Object)service1a);
            this.service1.destroy((Object)service1b);
            this.service2.destroy((Object)service2a);
            this.service2.destroy((Object)service2b);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void noSharingBetweenMethodsOfOneClass() {
        MutlipleMethodsCircuitBreakerLifecycleService multipleMethodsService1 = (MutlipleMethodsCircuitBreakerLifecycleService)this.multipleMethodsService.get();
        MutlipleMethodsCircuitBreakerLifecycleService multipleMethodsService2 = (MutlipleMethodsCircuitBreakerLifecycleService)this.multipleMethodsService.get();
        try {
            for (int i = 0; i < 4; ++i) {
                Assert.assertThrows(IOException.class, multipleMethodsService1::service1);
                Assert.assertThrows(IOException.class, multipleMethodsService1::service2);
                Assert.assertThrows(IOException.class, multipleMethodsService2::service1);
                Assert.assertThrows(IOException.class, multipleMethodsService2::service2);
            }
            Assert.assertThrows(CircuitBreakerOpenException.class, multipleMethodsService1::service1);
            Assert.assertThrows(CircuitBreakerOpenException.class, multipleMethodsService1::service2);
            Assert.assertThrows(CircuitBreakerOpenException.class, multipleMethodsService2::service1);
            Assert.assertThrows(CircuitBreakerOpenException.class, multipleMethodsService2::service2);
        }
        finally {
            this.multipleMethodsService.destroy((Object)multipleMethodsService1);
            this.multipleMethodsService.destroy((Object)multipleMethodsService2);
        }
    }
}

