/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck.util;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.enterprise.inject.spi.CDI;
import org.eclipse.microprofile.fault.tolerance.tck.asynchronous.CompletableFutureHelper;
import org.eclipse.microprofile.fault.tolerance.tck.util.AsyncCaller;
import org.eclipse.microprofile.fault.tolerance.tck.util.Barrier;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.Assert;

public class AsyncTaskManager
implements AutoCloseable {
    private List<BarrierTask<?>> startedTasks = Collections.synchronizedList(new ArrayList());
    private List<Barrier> createdNonTaskBarriers = Collections.synchronizedList(new ArrayList());

    public BarrierTask<Void> runBarrierTask(Consumer<Barrier> task) {
        Barrier barrier = new Barrier();
        Future<Void> future = this.getExecutor().run(() -> task.accept(barrier));
        BarrierTask<Void> taskImpl = new BarrierTask<Void>(future, barrier);
        this.startedTasks.add(taskImpl);
        return taskImpl;
    }

    public <T> BarrierTask<T> runAsyncBarrierTask(Function<Barrier, Future<? extends T>> task) {
        Barrier barrier = new Barrier();
        Future<? extends T> result = task.apply(barrier);
        BarrierTask<? extends T> taskImpl = new BarrierTask<T>(result, barrier);
        this.startedTasks.add(taskImpl);
        return taskImpl;
    }

    public <T> BarrierTask<T> runAsyncCsBarrierTask(Function<Barrier, CompletionStage<? extends T>> task) {
        Barrier barrier = new Barrier();
        CompletableFuture<? extends T> result = CompletableFutureHelper.toCompletableFuture(task.apply(barrier));
        BarrierTask<? extends T> taskImpl = new BarrierTask<T>(result, barrier);
        this.startedTasks.add(taskImpl);
        return taskImpl;
    }

    public Barrier newBarrier() {
        Barrier barrier = new Barrier();
        this.createdNonTaskBarriers.add(barrier);
        return barrier;
    }

    @Override
    public void close() {
        for (BarrierTask<?> barrierTask : this.startedTasks) {
            barrierTask.openBarrier();
        }
        for (Barrier barrier : this.createdNonTaskBarriers) {
            barrier.open();
        }
        try {
            for (BarrierTask barrierTask : this.startedTasks) {
                barrierTask.assertCompletes();
            }
        }
        finally {
            this.startedTasks.clear();
            this.createdNonTaskBarriers.clear();
        }
    }

    public static void assertAllNotAwaiting(Collection<? extends BarrierTask<?>> tasks) {
        Collection barriers = tasks.stream().map(t -> t).map(t -> ((BarrierTask)t).barrier).collect(Collectors.toList());
        Barrier.assertAllNotAwaiting(barriers);
    }

    private AsyncCaller getExecutor() {
        return (AsyncCaller)CDI.current().select(AsyncCaller.class, new Annotation[0]).get();
    }

    public static class BarrierTask<T> {
        private final Future<? extends T> result;
        private final Barrier barrier;

        public BarrierTask(Future<? extends T> result, Barrier barrier) {
            this.result = result;
            this.barrier = barrier;
        }

        public void openBarrier() {
            this.barrier.open();
        }

        public void assertAwaits() {
            this.barrier.assertAwaits();
        }

        public void assertNotAwaiting() {
            this.barrier.assertNotAwaiting();
        }

        public void assertCompletes() {
            block2: {
                try {
                    this.getResult();
                }
                catch (ExecutionException e) {
                    if (!(e.getCause() instanceof Error)) break block2;
                    Assert.fail((String)"Task completed but with an error", (Throwable)e.getCause());
                }
            }
        }

        public void assertNotCompleting() {
            try {
                T r = this.result.get(Barrier.EXPECTED_FAIL_TIME_MS, TimeUnit.MILLISECONDS);
                Assert.fail((String)("Task completed with result: " + r));
            }
            catch (ExecutionException e) {
                Assert.fail((String)"Task completed with exception", (Throwable)e);
            }
            catch (InterruptedException e) {
                Assert.fail((String)"Interrupted while checking task does not complete", (Throwable)e);
            }
            catch (TimeoutException timeoutException) {
                // empty catch block
            }
        }

        public void assertSuccess() {
            this.assertResult(Matchers.is((Matcher)Matchers.anything()));
        }

        public void assertThrows(Class<? extends Throwable> exceptionClass) {
            try {
                this.getResult();
                Assert.fail((String)"Task did not throw an exception");
            }
            catch (ExecutionException e) {
                MatcherAssert.assertThat((Object)e.getCause(), (Matcher)Matchers.instanceOf(exceptionClass));
            }
        }

        public void assertResult(Matcher<? super T> matcher) {
            try {
                T result = this.getResult();
                MatcherAssert.assertThat(result, matcher);
            }
            catch (ExecutionException e) {
                Assert.fail((String)"Task threw exception", (Throwable)e);
            }
        }

        public T getResult() throws ExecutionException {
            return this.getResult(Barrier.WAIT_TIME_MS, TimeUnit.MILLISECONDS);
        }

        public T getResult(long time, TimeUnit unit) throws ExecutionException {
            try {
                return this.result.get(time, unit);
            }
            catch (InterruptedException e) {
                throw new AssertionError("Interrupted while waiting for result", e);
            }
            catch (TimeoutException e) {
                throw new AssertionError("Timed out while waiting for result", e);
            }
        }

        public boolean isAwaiting() {
            return this.barrier.countWaiting() != 0;
        }
    }
}

