/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck.retrytimeout.clientserver;

import javax.enterprise.context.RequestScoped;
import org.eclipse.microprofile.fault.tolerance.tck.util.TCKConfig;
import org.eclipse.microprofile.faulttolerance.Retry;
import org.eclipse.microprofile.faulttolerance.Timeout;
import org.eclipse.microprofile.faulttolerance.exceptions.BulkheadException;
import org.eclipse.microprofile.faulttolerance.exceptions.TimeoutException;
import org.testng.Assert;

@RequestScoped
public class RetryTimeoutClient {
    private int counterForInvokingServiceA = 0;
    private int counterForInvokingServiceWithoutRetryOn = 0;
    private int counterForInvokingServiceWithAbortOn = 0;
    private TCKConfig config = TCKConfig.getConfig();

    public int getCounterForInvokingServiceA() {
        return this.counterForInvokingServiceA;
    }

    public int getCounterForInvokingServiceWithoutRetryOn() {
        return this.counterForInvokingServiceWithoutRetryOn;
    }

    public int getCounterForInvokingServiceWithAbortOn() {
        return this.counterForInvokingServiceWithAbortOn;
    }

    @Timeout(value=500L)
    @Retry(maxRetries=1)
    public String serviceA(long timeToSleep) {
        try {
            ++this.counterForInvokingServiceA;
            Thread.sleep(timeToSleep);
            throw new RuntimeException("Timeout did not interrupt");
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
    }

    @Timeout(value=500L)
    @Retry(maxRetries=1, retryOn={BulkheadException.class})
    public String serviceWithoutRetryOn() {
        try {
            ++this.counterForInvokingServiceWithoutRetryOn;
            Thread.sleep(this.config.getTimeoutInMillis(1000L));
            Assert.fail((String)"Timeout did not interrupt");
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return null;
    }

    @Timeout(value=500L)
    @Retry(maxRetries=1, abortOn={TimeoutException.class})
    public String serviceWithAbortOn() {
        try {
            ++this.counterForInvokingServiceWithAbortOn;
            Thread.sleep(this.config.getTimeoutInMillis(1000L));
            Assert.fail((String)"Timeout did not interrupt");
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return null;
    }
}

