/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck.retry.clientserver;

import java.io.IOException;
import java.sql.Connection;
import javax.enterprise.context.RequestScoped;
import org.eclipse.microprofile.faulttolerance.Retry;

@RequestScoped
public class RetryClientAbortOn {
    private int counterForInvokingConnenectionService;
    private int counterForInvokingWritingService;

    @Retry(abortOn={IOException.class})
    public Connection serviceA() {
        return this.connectionService();
    }

    private Connection connectionService() {
        ++this.counterForInvokingConnenectionService;
        throw new RuntimeException("Connection failed");
    }

    public int getRetryCountForConnectionService() {
        return this.counterForInvokingConnenectionService;
    }

    @Retry(abortOn={RuntimeException.class})
    public void serviceB() {
        this.writingService();
    }

    private void writingService() {
        ++this.counterForInvokingWritingService;
        try {
            Thread.sleep(100L);
            throw new RuntimeException("WritingService failed");
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return;
        }
    }

    public int getRetryCountForWritingService() {
        return this.counterForInvokingWritingService;
    }
}

