/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck.metrics;

import javax.inject.Inject;
import org.eclipse.microprofile.fault.tolerance.tck.metrics.ClassLevelMetricBean;
import org.eclipse.microprofile.fault.tolerance.tck.metrics.util.MetricDefinition;
import org.eclipse.microprofile.fault.tolerance.tck.metrics.util.MetricGetter;
import org.eclipse.microprofile.fault.tolerance.tck.util.Exceptions;
import org.eclipse.microprofile.fault.tolerance.tck.util.Packages;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.annotations.Test;

public class ClassLevelMetricTest
extends Arquillian {
    @Inject
    private ClassLevelMetricBean classLevelRetryBean;

    @Deployment
    public static WebArchive deploy() {
        WebArchive war = (WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"ftMetricClassLevel.war")).addClasses(new Class[]{ClassLevelMetricBean.class})).addPackage(Packages.UTILS)).addPackage(Packages.METRIC_UTILS)).addAsWebInfResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        return war;
    }

    @Test
    public void testRetryMetricSuccessfulImmediately() {
        MetricGetter m = new MetricGetter(ClassLevelMetricBean.class, "failSeveralTimes");
        m.baselineMetrics();
        this.classLevelRetryBean.failSeveralTimes(0);
        this.assertRetryCallsIncremented(m, MetricDefinition.RetryRetried.FALSE, MetricDefinition.RetryResult.VALUE_RETURNED, 1L);
        MatcherAssert.assertThat((String)"retries", (Object)m.getRetryRetries().delta(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"invocations returning value", (Object)m.getInvocations(MetricDefinition.InvocationResult.VALUE_RETURNED, MetricDefinition.InvocationFallback.NOT_DEFINED).delta(), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((String)"invocations throwing exception", (Object)m.getInvocations(MetricDefinition.InvocationResult.EXCEPTION_THROWN, MetricDefinition.InvocationFallback.NOT_DEFINED).delta(), (Matcher)Matchers.is((Object)0L));
    }

    @Test
    public void testRetryMetricSuccessfulAfterRetry() {
        MetricGetter m = new MetricGetter(ClassLevelMetricBean.class, "failSeveralTimes");
        m.baselineMetrics();
        this.classLevelRetryBean.failSeveralTimes(3);
        this.assertRetryCallsIncremented(m, MetricDefinition.RetryRetried.TRUE, MetricDefinition.RetryResult.VALUE_RETURNED, 1L);
        MatcherAssert.assertThat((String)"retries", (Object)m.getRetryRetries().delta(), (Matcher)Matchers.is((Object)3L));
        MatcherAssert.assertThat((String)"invocations returning value", (Object)m.getInvocations(MetricDefinition.InvocationResult.VALUE_RETURNED, MetricDefinition.InvocationFallback.NOT_DEFINED).delta(), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((String)"invocations throwing exception", (Object)m.getInvocations(MetricDefinition.InvocationResult.EXCEPTION_THROWN, MetricDefinition.InvocationFallback.NOT_DEFINED).delta(), (Matcher)Matchers.is((Object)0L));
    }

    @Test
    public void testRetryMetricUnsuccessful() {
        MetricGetter m = new MetricGetter(ClassLevelMetricBean.class, "failSeveralTimes");
        m.baselineMetrics();
        Exceptions.expectTestException(() -> this.classLevelRetryBean.failSeveralTimes(20));
        Exceptions.expectTestException(() -> this.classLevelRetryBean.failSeveralTimes(20));
        this.assertRetryCallsIncremented(m, MetricDefinition.RetryRetried.TRUE, MetricDefinition.RetryResult.MAX_RETRIES_REACHED, 2L);
        MatcherAssert.assertThat((String)"retries", (Object)m.getRetryRetries().delta(), (Matcher)Matchers.is((Object)10L));
        MatcherAssert.assertThat((String)"invocations returning value", (Object)m.getInvocations(MetricDefinition.InvocationResult.VALUE_RETURNED, MetricDefinition.InvocationFallback.NOT_DEFINED).delta(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"invocations throwing exception", (Object)m.getInvocations(MetricDefinition.InvocationResult.EXCEPTION_THROWN, MetricDefinition.InvocationFallback.NOT_DEFINED).delta(), (Matcher)Matchers.is((Object)2L));
    }

    private void assertRetryCallsIncremented(MetricGetter m, MetricDefinition.RetryRetried retriedValue, MetricDefinition.RetryResult resultValue, Long expectedDelta) {
        for (MetricDefinition.RetryRetried retried : MetricDefinition.RetryRetried.values()) {
            for (MetricDefinition.RetryResult result : MetricDefinition.RetryResult.values()) {
                if (retried == retriedValue && result == resultValue) {
                    MatcherAssert.assertThat((String)("Retry calls (" + retried + ", " + result + ")"), (Object)m.getRetryCalls(retried, result).delta(), (Matcher)Matchers.is((Object)expectedDelta));
                    continue;
                }
                MatcherAssert.assertThat((String)("Retry calls (" + retried + ", " + result + ")"), (Object)m.getRetryCalls(retried, result).delta(), (Matcher)Matchers.is((Object)0L));
            }
        }
    }
}

