/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck.config;

import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.eclipse.microprofile.fault.tolerance.tck.asynchronous.CompletableFutureHelper;
import org.eclipse.microprofile.fault.tolerance.tck.config.ConfigAnnotationAsset;
import org.eclipse.microprofile.fault.tolerance.tck.config.TimeoutConfigBean;
import org.eclipse.microprofile.fault.tolerance.tck.util.Exceptions;
import org.eclipse.microprofile.fault.tolerance.tck.util.Packages;
import org.eclipse.microprofile.fault.tolerance.tck.util.TCKConfig;
import org.eclipse.microprofile.faulttolerance.Timeout;
import org.eclipse.microprofile.faulttolerance.exceptions.TimeoutException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.annotations.Test;

public class TimeoutConfigTest
extends Arquillian {
    @Inject
    private TimeoutConfigBean bean;

    @Deployment
    public static WebArchive create() {
        ConfigAnnotationAsset config = new ConfigAnnotationAsset().set(TimeoutConfigBean.class, "serviceValue", Timeout.class, "value", TCKConfig.getConfig().getTimeoutInStr(1000L)).set(TimeoutConfigBean.class, "serviceUnit", Timeout.class, "value", TCKConfig.getConfig().getTimeoutInStr(1000L)).set(TimeoutConfigBean.class, "serviceUnit", Timeout.class, "unit", "MILLIS").set(TimeoutConfigBean.class, "serviceBoth", Timeout.class, "value", TCKConfig.getConfig().getTimeoutInStr(1000L)).set(TimeoutConfigBean.class, "serviceBoth", Timeout.class, "unit", "MILLIS");
        JavaArchive jar = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"ftTimeoutConfig.jar")).addClasses(new Class[]{TimeoutConfigBean.class, CompletableFutureHelper.class})).addPackage(Packages.UTILS)).addAsManifestResource((Asset)config, "microprofile-config.properties")).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        return (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"ftTimeoutConfig.war")).addAsLibrary((Archive)jar);
    }

    @Test
    public void testConfigValue() {
        this.doTest(() -> this.bean.serviceValue());
    }

    @Test
    public void testConfigUnit() {
        this.doTest(() -> this.bean.serviceUnit());
    }

    @Test
    public void testConfigBoth() {
        this.doTest(() -> {
            try {
                CompletableFutureHelper.toCompletableFuture(this.bean.serviceBoth()).get(1L, TimeUnit.MINUTES);
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof Exception) {
                    throw (Exception)e.getCause();
                }
                throw e;
            }
        });
    }

    private void doTest(Exceptions.ExceptionThrowingAction action) {
        long start = System.nanoTime();
        Exceptions.expect(TimeoutException.class, action);
        long end = System.nanoTime();
        long durationInMillis = Duration.ofNanos(end - start).toMillis();
        MatcherAssert.assertThat((Object)durationInMillis, (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(TCKConfig.getConfig().getTimeoutInMillis(800L))));
        MatcherAssert.assertThat((Object)durationInMillis, (Matcher)Matchers.lessThan((Comparable)Long.valueOf(TCKConfig.getConfig().getTimeoutInMillis(2000L))));
    }
}

