/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck.config;

import java.time.Duration;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.awaitility.Awaitility;
import org.eclipse.microprofile.fault.tolerance.tck.config.CircuitBreakerConfigBean;
import org.eclipse.microprofile.fault.tolerance.tck.config.ConfigAnnotationAsset;
import org.eclipse.microprofile.fault.tolerance.tck.config.TestConfigExceptionA;
import org.eclipse.microprofile.fault.tolerance.tck.config.TestConfigExceptionB;
import org.eclipse.microprofile.fault.tolerance.tck.util.Exceptions;
import org.eclipse.microprofile.fault.tolerance.tck.util.Packages;
import org.eclipse.microprofile.fault.tolerance.tck.util.TCKConfig;
import org.eclipse.microprofile.faulttolerance.CircuitBreaker;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.annotations.Test;

public class CircuitBreakerConfigTest
extends Arquillian {
    @Inject
    private CircuitBreakerConfigBean bean;

    @Deployment
    public static WebArchive create() {
        ConfigAnnotationAsset config = new ConfigAnnotationAsset().set(CircuitBreakerConfigBean.class, "skipOnMethod", CircuitBreaker.class, "skipOn", TestConfigExceptionA.class.getName()).set(CircuitBreakerConfigBean.class, "failOnMethod", CircuitBreaker.class, "failOn", TestConfigExceptionA.class.getName()).set(CircuitBreakerConfigBean.class, "delayMethod", CircuitBreaker.class, "delay", TCKConfig.getConfig().getTimeoutInStr(1000L)).set(CircuitBreakerConfigBean.class, "delayMethod", CircuitBreaker.class, "delayUnit", "MILLIS").set(CircuitBreakerConfigBean.class, "requestVolumeThresholdMethod", CircuitBreaker.class, "requestVolumeThreshold", "4").set(CircuitBreakerConfigBean.class, "failureRatioMethod", CircuitBreaker.class, "failureRatio", "0.8").set(CircuitBreakerConfigBean.class, "successThresholdMethod", CircuitBreaker.class, "successThreshold", "2").set(CircuitBreakerConfigBean.class, "successThresholdMethod", CircuitBreaker.class, "delay", TCKConfig.getConfig().getTimeoutInStr(1000L));
        JavaArchive jar = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"ftCircuitBreakerConfig.jar")).addClasses(new Class[]{CircuitBreakerConfigBean.class, TestConfigExceptionA.class, TestConfigExceptionB.class})).addPackage(Packages.UTILS)).addAsManifestResource((Asset)config, "microprofile-config.properties")).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        return (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"ftCircuitBreakerConfig.war")).addAsLibraries(new Archive[]{jar});
    }

    @Test
    public void testConfigureFailOn() {
        Exceptions.expect(TestConfigExceptionA.class, () -> this.bean.failOnMethod());
        Exceptions.expect(TestConfigExceptionA.class, () -> this.bean.failOnMethod());
        Exceptions.expectCbOpen(() -> this.bean.failOnMethod());
    }

    @Test
    public void testConfigureSkipOn() {
        Exceptions.expect(TestConfigExceptionA.class, () -> this.bean.skipOnMethod());
        Exceptions.expect(TestConfigExceptionA.class, () -> this.bean.skipOnMethod());
        Exceptions.expect(TestConfigExceptionA.class, () -> this.bean.skipOnMethod());
    }

    @Test
    public void testConfigureDelay() {
        Exceptions.expect(TestConfigExceptionA.class, () -> this.bean.delayMethod(true));
        Exceptions.expect(TestConfigExceptionA.class, () -> this.bean.delayMethod(true));
        Exceptions.expectCbOpen(() -> this.bean.delayMethod(false));
        long start = System.nanoTime();
        Awaitility.await().atMost(1L, TimeUnit.MINUTES).untilAsserted(() -> Exceptions.expectNoException(() -> this.bean.delayMethod(false)));
        long end = System.nanoTime();
        long durationInMillis = Duration.ofNanos(end - start).toMillis();
        MatcherAssert.assertThat((Object)durationInMillis, (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(TCKConfig.getConfig().getTimeoutInMillis(800L))));
        MatcherAssert.assertThat((Object)durationInMillis, (Matcher)Matchers.lessThan((Comparable)Long.valueOf(TCKConfig.getConfig().getTimeoutInMillis(2000L))));
    }

    @Test
    public void testConfigureRequestVolumeThreshold() {
        Exceptions.expect(TestConfigExceptionA.class, () -> this.bean.requestVolumeThresholdMethod());
        Exceptions.expect(TestConfigExceptionA.class, () -> this.bean.requestVolumeThresholdMethod());
        Exceptions.expect(TestConfigExceptionA.class, () -> this.bean.requestVolumeThresholdMethod());
        Exceptions.expect(TestConfigExceptionA.class, () -> this.bean.requestVolumeThresholdMethod());
        Exceptions.expectCbOpen(() -> this.bean.requestVolumeThresholdMethod());
    }

    @Test
    public void testConfigureFailureRatio() {
        Exceptions.expect(TestConfigExceptionA.class, () -> this.bean.failureRatioMethod(true));
        Exceptions.expect(TestConfigExceptionA.class, () -> this.bean.failureRatioMethod(true));
        Exceptions.expectNoException(() -> this.bean.failureRatioMethod(false));
        Exceptions.expect(TestConfigExceptionA.class, () -> this.bean.failureRatioMethod(true));
        Exceptions.expect(TestConfigExceptionA.class, () -> this.bean.failureRatioMethod(true));
        Exceptions.expect(TestConfigExceptionA.class, () -> this.bean.failureRatioMethod(true));
        Exceptions.expectNoException(() -> this.bean.failureRatioMethod(false));
        Exceptions.expect(TestConfigExceptionA.class, () -> this.bean.failureRatioMethod(true));
        Exceptions.expect(TestConfigExceptionA.class, () -> this.bean.failureRatioMethod(true));
        Exceptions.expect(TestConfigExceptionA.class, () -> this.bean.failureRatioMethod(true));
        Exceptions.expectCbOpen(() -> this.bean.failureRatioMethod(false));
    }

    @Test
    public void testConfigureSuccessThreshold() {
        int i;
        for (i = 0; i < 10; ++i) {
            Exceptions.expect(TestConfigExceptionA.class, () -> this.bean.successThresholdMethod(true));
        }
        Exceptions.expectCbOpen(() -> this.bean.successThresholdMethod(false));
        Awaitility.await().atMost(1L, TimeUnit.MINUTES).untilAsserted(() -> Exceptions.expectNoException(() -> this.bean.successThresholdMethod(false)));
        Exceptions.expectNoException(() -> this.bean.successThresholdMethod(false));
        for (i = 0; i < 10; ++i) {
            Exceptions.expect(TestConfigExceptionA.class, () -> this.bean.successThresholdMethod(true));
        }
        Exceptions.expectCbOpen(() -> this.bean.successThresholdMethod(false));
        Awaitility.await().atMost(1L, TimeUnit.MINUTES).untilAsserted(() -> Exceptions.expectNoException(() -> this.bean.successThresholdMethod(false)));
        Exceptions.expect(TestConfigExceptionA.class, () -> this.bean.successThresholdMethod(true));
        Exceptions.expectCbOpen(() -> this.bean.successThresholdMethod(false));
    }
}

