/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck.circuitbreaker;

import javax.inject.Inject;
import org.eclipse.microprofile.fault.tolerance.tck.Misc;
import org.eclipse.microprofile.fault.tolerance.tck.circuitbreaker.clientserver.CircuitBreakerClientDefaultSuccessThreshold;
import org.eclipse.microprofile.faulttolerance.exceptions.CircuitBreakerOpenException;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.Test;

public class CircuitBreakerConfigOnMethodTest
extends Arquillian {
    @Inject
    private CircuitBreakerClientDefaultSuccessThreshold clientForCBDefaultSuccess;

    @Deployment
    public static WebArchive deploy() {
        JavaArchive testJar = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"ftCircuitBreaker.jar")).addClasses(new Class[]{CircuitBreakerClientDefaultSuccessThreshold.class, Misc.class})).addAsManifestResource((Asset)new StringAsset("org.eclipse.microprofile.fault.tolerance.tck.circuitbreaker.clientserver.CircuitBreakerClientDefaultSuccessThreshold/serviceA/CircuitBreaker/delay=200"), "microprofile-config.properties")).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml")).as(JavaArchive.class);
        WebArchive war = (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"ftCircuitBreaker.war")).addAsLibrary((Archive)testJar);
        return war;
    }

    @Test
    public void testCircuitDefaultSuccessThreshold() {
        for (int i = 1; i < 12; ++i) {
            int[] successSet = new int[]{5};
            try {
                this.clientForCBDefaultSuccess.serviceA(successSet);
                if (i == 6) continue;
                Assert.fail((String)("serviceA should throw an Exception in testCircuitDefaultSuccessThreshold on iteration " + i));
                continue;
            }
            catch (CircuitBreakerOpenException cboe) {
                if (!Misc.Ints.contains(new int[]{5, 11}, i)) {
                    Assert.fail((String)("in serviceA no CircuitBreakerOpenException should be fired on iteration " + i));
                    continue;
                }
                if (i != 5) continue;
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                continue;
            }
            catch (RuntimeException ex) {
                if (Misc.Ints.contains(new int[]{1, 2, 3, 4, 7, 8, 9, 10}, i)) continue;
                Assert.fail((String)("serviceA should not throw a RuntimeException on iteration " + i));
                continue;
            }
            catch (Exception ex) {
                Assert.fail((String)("serviceA should throw a RuntimeException or CircuitBreakerOpenException in testCircuitDefaultSuccessThreshold on iteration " + i));
            }
        }
        int serviceAExecutions = this.clientForCBDefaultSuccess.getCounterForInvokingServiceA();
        Assert.assertEquals((int)serviceAExecutions, (int)9, (String)"The number of serviceA executions should be 9");
    }
}

