/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck.bulkhead;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.awaitility.Awaitility;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.BulkheadPressureBean;
import org.eclipse.microprofile.fault.tolerance.tck.util.AsyncCaller;
import org.eclipse.microprofile.fault.tolerance.tck.util.Packages;
import org.eclipse.microprofile.fault.tolerance.tck.util.TCKConfig;
import org.eclipse.microprofile.faulttolerance.exceptions.BulkheadException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.Test;

public class BulkheadPressureTest
extends Arquillian {
    private TCKConfig config = TCKConfig.getConfig();
    @Inject
    private AsyncCaller executor;
    @Inject
    private BulkheadPressureBean bean;

    @Deployment
    public static WebArchive deployment() {
        JavaArchive jar = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"ftBulkheadPressure.jar")).addPackage(Packages.UTILS)).addClass(BulkheadPressureBean.class)).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        WebArchive war = (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"ftBulkheadPressure.war")).addAsLibraries(new Archive[]{jar});
        return war;
    }

    @Test
    public void testBulkheadPressureSync() throws InterruptedException {
        this.bean.reset();
        ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>();
        try {
            for (int i = 0; i < 100; ++i) {
                futures.add(this.executor.run(() -> this.bean.servicePressure(this.config.getTimeoutInMillis(50L))));
                Thread.sleep(this.config.getTimeoutInMillis(25L));
            }
        }
        finally {
            Awaitility.await().untilAsserted(() -> futures.forEach(f -> Assert.assertTrue((boolean)f.isDone())));
        }
        Map<ResultCategory, List<Future>> results = futures.stream().collect(Collectors.groupingBy(this::getResultCategory));
        MatcherAssert.assertThat((String)"Calls returning successfully", results.get((Object)ResultCategory.NO_EXCEPTION), (Matcher)Matchers.hasSize((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(5))));
        MatcherAssert.assertThat((String)"Calls throwing non-bulkhead exception", results.get((Object)ResultCategory.OTHER_EXCEPTION), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((String)"Max concurrent tasks", (Object)this.bean.getMaxInProgress(), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(5)));
    }

    @Test
    public void testBulkheadPressureAsync() throws InterruptedException {
        this.bean.reset();
        ArrayList futures = new ArrayList();
        try {
            for (int i = 0; i < 100; ++i) {
                futures.add(this.bean.servicePressureAsync(this.config.getTimeoutInMillis(50L)));
                Thread.sleep(this.config.getTimeoutInMillis(25L));
            }
        }
        finally {
            Awaitility.await().untilAsserted(() -> futures.forEach(f -> Assert.assertTrue((boolean)f.isDone())));
        }
        Map<ResultCategory, List<Future>> results = futures.stream().collect(Collectors.groupingBy(this::getResultCategory));
        MatcherAssert.assertThat((String)"Calls returning successfully", results.get((Object)ResultCategory.NO_EXCEPTION), (Matcher)Matchers.hasSize((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(10))));
        MatcherAssert.assertThat((String)"Calls throwing non-bulkhead exception", results.get((Object)ResultCategory.OTHER_EXCEPTION), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((String)"Max concurrent tasks", (Object)this.bean.getMaxInProgress(), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(5)));
    }

    private ResultCategory getResultCategory(Future<?> future) {
        Assert.assertTrue((boolean)future.isDone(), (String)"Checking result category when future is not done");
        try {
            future.get();
            return ResultCategory.NO_EXCEPTION;
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof BulkheadException) {
                return ResultCategory.BULKHEAD_EXCEPTION;
            }
            return ResultCategory.OTHER_EXCEPTION;
        }
        catch (InterruptedException e) {
            throw new AssertionError("Interrupted getting result category", e);
        }
    }

    private static enum ResultCategory {
        BULKHEAD_EXCEPTION,
        OTHER_EXCEPTION,
        NO_EXCEPTION;

    }
}

