/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck.asynchronous;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.enterprise.context.RequestScoped;
import org.eclipse.microprofile.fault.tolerance.tck.asynchronous.CompletableFutureHelper;
import org.eclipse.microprofile.fault.tolerance.tck.util.Connection;
import org.eclipse.microprofile.faulttolerance.Asynchronous;

@RequestScoped
@Asynchronous
public class AsyncClassLevelClient {
    @Asynchronous
    public Future<Connection> service(Future<?> waitCondition) {
        return CompletableFutureHelper.toCompletableFuture(this.serviceCS(waitCondition, false));
    }

    public CompletionStage<Connection> serviceCS(Future<?> waitCondition, boolean throwException) {
        Throwable exception = null;
        try {
            waitCondition.get(1000L, TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            exception = e.getCause();
        }
        catch (InterruptedException | TimeoutException e) {
            exception = e;
        }
        if (exception != null) {
            if (throwException) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new RuntimeException(exception);
            }
            return CompletableFutureHelper.failedFuture(exception);
        }
        return CompletableFuture.completedFuture(new Connection(){

            @Override
            public String getData() {
                return "service DATA";
            }
        });
    }

    public CompletionStage<Connection> serviceCS(Future<?> waitCondition) {
        return this.serviceCS(waitCondition, false);
    }
}

