/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck;

import javax.inject.Inject;
import org.eclipse.microprofile.fault.tolerance.tck.config.clientserver.ConfigClassLevelClient;
import org.eclipse.microprofile.fault.tolerance.tck.config.clientserver.ConfigClassLevelMaxDurationClient;
import org.eclipse.microprofile.fault.tolerance.tck.config.clientserver.ConfigClient;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ConfigTest
extends Arquillian {
    @Inject
    private ConfigClient clientForConfig;
    @Inject
    private ConfigClassLevelClient clientForClassLevelConfig;
    @Inject
    private ConfigClassLevelMaxDurationClient clientForClassLevelMaxDurationConfig;

    @Deployment
    public static WebArchive deploy() {
        JavaArchive testJar = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"ftConfig.jar")).addClasses(new Class[]{ConfigClient.class, ConfigClassLevelClient.class, ConfigClassLevelMaxDurationClient.class})).addAsManifestResource((Asset)new StringAsset("org.eclipse.microprofile.fault.tolerance.tck.config.clientserver.ConfigClient/serviceA/Retry/maxRetries=3\norg.eclipse.microprofile.fault.tolerance.tck.config.clientserver.ConfigClassLevelClient/Retry/maxRetries=3\norg.eclipse.microprofile.fault.tolerance.tck.config.clientserver.ConfigClient/serviceC/Retry/maxDuration=1000\norg.eclipse.microprofile.fault.tolerance.tck.config.clientserver.ConfigClassLevelMaxDurationClient/Retry/maxDuration=1000"), "microprofile-config.properties")).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml")).as(JavaArchive.class);
        WebArchive war = (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"ftConfig.war")).addAsLibrary((Archive)testJar);
        return war;
    }

    @Test
    public void testConfigMaxRetries() {
        try {
            this.clientForConfig.serviceA();
            Assert.fail((String)"serviceA should throw a RuntimeException in testConfigMaxRetries");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        int count = this.clientForConfig.getCounterForInvokingConnectionService();
        Assert.assertEquals((int)count, (int)4, (String)"The max number of execution should be 4");
    }

    @Test
    public void testClassLevelConfigMaxRetries() {
        try {
            this.clientForClassLevelConfig.serviceA();
            Assert.fail((String)"serviceA should throw a RuntimeException in testClassLevelConfigMaxRetries");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        int count = this.clientForClassLevelConfig.getCounterForInvokingConnectionService();
        Assert.assertEquals((int)count, (int)4, (String)"The max number of execution should be 4");
    }

    @Test
    public void testClassLevelConfigMethodOverrideMaxRetries() {
        try {
            this.clientForClassLevelConfig.serviceB();
            Assert.fail((String)"serviceB should throw a RuntimeException in testClassLevelConfigMethodOverrideMaxRetries");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        int count = this.clientForClassLevelConfig.getCounterForInvokingConnectionService();
        Assert.assertEquals((int)count, (int)2, (String)"The max number of execution should be 2");
    }

    @Test
    public void testConfigMaxDuration() {
        try {
            this.clientForConfig.serviceC();
            Assert.fail((String)"serviceC should throw a RuntimeException in testConfigMaxDuration");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        int count = this.clientForConfig.getRetryCountForWritingService();
        Assert.assertTrue((count <= 11 ? 1 : 0) != 0, (String)"The max retry counter should be 11 or less");
    }

    @Test
    public void testClassLevelConfigMaxDuration() {
        try {
            this.clientForClassLevelMaxDurationConfig.serviceA();
            Assert.fail((String)"serviceB should throw a RuntimeException in testClassLevelConfigMaxDuration");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        int retryCountforWritingService = this.clientForClassLevelMaxDurationConfig.getRetryCountForWritingService();
        Assert.assertTrue((retryCountforWritingService <= 11 ? 1 : 0) != 0, (String)"The max retry counter should be 11 or less");
    }
}

