/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import javax.inject.Inject;
import org.eclipse.microprofile.fault.tolerance.tck.circuitbreaker.clientserver.CircuitBreakerClientWithAsyncBulkhead;
import org.eclipse.microprofile.fault.tolerance.tck.circuitbreaker.clientserver.CircuitBreakerClientWithAsyncBulkheadNoFail;
import org.eclipse.microprofile.fault.tolerance.tck.circuitbreaker.clientserver.CircuitBreakerClientWithSyncBulkhead;
import org.eclipse.microprofile.fault.tolerance.tck.util.AsyncTaskManager;
import org.eclipse.microprofile.fault.tolerance.tck.util.Packages;
import org.eclipse.microprofile.faulttolerance.exceptions.BulkheadException;
import org.eclipse.microprofile.faulttolerance.exceptions.CircuitBreakerOpenException;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.annotations.Test;

public class CircuitBreakerBulkheadTest
extends Arquillian {
    @Inject
    private CircuitBreakerClientWithAsyncBulkhead asyncBulkheadClient;
    @Inject
    private CircuitBreakerClientWithSyncBulkhead syncBulkheadClient;
    @Inject
    private CircuitBreakerClientWithAsyncBulkheadNoFail asyncBulkheadNoFailClient;

    @Deployment
    public static WebArchive deploy() {
        JavaArchive testJar = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"ftCircuitBreakerBulkhead.jar")).addClasses(new Class[]{CircuitBreakerClientWithAsyncBulkhead.class, CircuitBreakerClientWithSyncBulkhead.class, CircuitBreakerClientWithAsyncBulkheadNoFail.class})).addPackage(Packages.UTILS)).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml")).as(JavaArchive.class);
        WebArchive war = (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"ftCircuitBreakerBulkhead.war")).addAsLibrary((Archive)testJar);
        return war;
    }

    @Test
    public void testCircuitBreakerAroundBulkheadAsync() throws InterruptedException, ExecutionException, TimeoutException {
        try (AsyncTaskManager taskManager = new AsyncTaskManager();){
            AsyncTaskManager.BarrierTask taski;
            int i;
            AsyncTaskManager.BarrierTask task1 = taskManager.runAsyncBarrierTask(this.asyncBulkheadClient::test);
            task1.assertAwaits();
            AsyncTaskManager.BarrierTask task2 = taskManager.runAsyncBarrierTask(this.asyncBulkheadClient::test);
            task2.assertNotAwaiting();
            for (i = 3; i < 6; ++i) {
                taski = taskManager.runAsyncBarrierTask(this.asyncBulkheadClient::test);
                taski.assertThrows(BulkheadException.class);
            }
            for (i = 6; i < 8; ++i) {
                taski = taskManager.runAsyncBarrierTask(this.asyncBulkheadClient::test);
                taski.assertThrows(CircuitBreakerOpenException.class);
            }
            task1.openBarrier();
            task1.assertSuccess();
            task2.openBarrier();
            task2.assertSuccess();
        }
    }

    @Test
    public void testCircuitBreakerAroundBulkheadSync() throws InterruptedException, ExecutionException, TimeoutException {
        try (AsyncTaskManager taskManager = new AsyncTaskManager();){
            AsyncTaskManager.BarrierTask<Void> taski;
            int i;
            AsyncTaskManager.BarrierTask<Void> task1 = taskManager.runBarrierTask(this.syncBulkheadClient::test);
            task1.assertAwaits();
            for (i = 2; i < 5; ++i) {
                taski = taskManager.runBarrierTask(this.syncBulkheadClient::test);
                taski.assertThrows(BulkheadException.class);
            }
            for (i = 5; i < 7; ++i) {
                taski = taskManager.runBarrierTask(this.syncBulkheadClient::test);
                taski.assertThrows(CircuitBreakerOpenException.class);
            }
            task1.openBarrier();
            task1.assertSuccess();
        }
    }

    @Test
    public void testCircuitBreaker() throws InterruptedException, ExecutionException, TimeoutException {
        try (AsyncTaskManager taskManager = new AsyncTaskManager();){
            AsyncTaskManager.BarrierTask task1 = taskManager.runAsyncBarrierTask(this.asyncBulkheadNoFailClient::test);
            task1.assertAwaits();
            AsyncTaskManager.BarrierTask task2 = taskManager.runAsyncBarrierTask(this.asyncBulkheadNoFailClient::test);
            task2.assertNotAwaiting();
            for (int i = 3; i < 8; ++i) {
                AsyncTaskManager.BarrierTask taski = taskManager.runAsyncBarrierTask(this.asyncBulkheadNoFailClient::test);
                taski.assertThrows(BulkheadException.class);
            }
            task1.openBarrier();
            task1.assertSuccess();
            task2.openBarrier();
            task2.assertSuccess();
        }
    }
}

