/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.config.tck;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

public class PropertyExpressionsTest
extends Arquillian {
    private List<Config> builtConfigs = new ArrayList<Config>();

    @Deployment
    public static WebArchive deployment() {
        JavaArchive testJar = (JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"PropertyExpressionsTest.jar")).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml")).as(JavaArchive.class);
        return (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"PropertyExpressionsTest.war")).addAsLibrary((Archive)testJar);
    }

    @AfterMethod
    public void tearDown() {
        for (Config config : this.builtConfigs) {
            ConfigProviderResolver.instance().releaseConfig(config);
        }
        this.builtConfigs.clear();
    }

    @Test
    public void simpleExpression() {
        Config config = this.buildConfig("my.prop", "1234", "expression", "${my.prop}");
        Assert.assertEquals((String)"1234", (String)((String)config.getValue("expression", String.class)));
    }

    @Test
    public void multipleExpressions() {
        Config config = this.buildConfig("my.prop", "1234", "expression", "${my.prop}${my.prop}");
        Assert.assertEquals((String)"12341234", (String)((String)config.getValue("expression", String.class)));
    }

    @Test
    public void composedExpressions() {
        Config config = this.buildConfig("my.prop", "1234", "expression", "${${compose}}", "compose", "my.prop");
        Assert.assertEquals((String)"1234", (String)((String)config.getValue("expression", String.class)));
    }

    @Test
    public void defaultExpression() {
        Config config = this.buildConfig("expression", "${my.prop:1234}");
        Assert.assertEquals((String)"1234", (String)((String)config.getValue("expression", String.class)));
    }

    @Test
    public void defaultExpressionEmpty() {
        Config config = this.buildConfig("expression", "12${my.prop:}34");
        Assert.assertEquals((String)"1234", (String)((String)config.getValue("expression", String.class)));
    }

    @Test
    public void defaultExpressionComposed() {
        Config config = this.buildConfig("expression", "${my.prop:${compose}}", "compose", "1234");
        Assert.assertEquals((String)"1234", (String)((String)config.getValue("expression", String.class)));
    }

    @Test
    public void defaultExpressionComposedEmpty() {
        Config config = this.buildConfig("expression", "${my.prop:${compose:}}", "my.prop", "1234");
        Assert.assertEquals((String)"1234", (String)((String)config.getValue("expression", String.class)));
    }

    @Test
    public void noExpression() {
        Config config = this.buildConfig("expression", "${my.prop}");
        Assert.assertThrows(NoSuchElementException.class, () -> {
            String cfr_ignored_0 = (String)config.getValue("expression", String.class);
        });
    }

    @Test
    public void noExpressionComposed() {
        Config config = this.buildConfig("expression", "${my.prop${compose}}");
        Assert.assertThrows(NoSuchElementException.class, () -> {
            String cfr_ignored_0 = (String)config.getValue("expression", String.class);
        });
    }

    @Test
    public void multipleExpansions() {
        Config config = this.buildConfig("my.prop", "1234", "my.prop.two", "${my.prop}", "my.prop.three", "${my.prop.two}", "my.prop.four", "${my.prop.three}");
        Assert.assertEquals((String)"1234", (String)((String)config.getValue("my.prop", String.class)));
        Assert.assertEquals((String)"1234", (String)((String)config.getValue("my.prop.two", String.class)));
        Assert.assertEquals((String)"1234", (String)((String)config.getValue("my.prop.three", String.class)));
        Assert.assertEquals((String)"1234", (String)((String)config.getValue("my.prop.four", String.class)));
    }

    @Test
    public void infiniteExpansion() {
        Config config = this.buildConfig("my.prop", "${my.prop}");
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            String cfr_ignored_0 = (String)config.getValue("my.prop", String.class);
        });
    }

    @Test
    public void withoutExpansion() {
        Config config = this.buildConfig("my.prop", "1234", "expression", "${my.prop}", "mp.config.property.expressions.enabled", "false");
        Assert.assertEquals((String)"${my.prop}", (String)((String)config.getValue("expression", String.class)));
    }

    @Test
    public void escape() {
        Assert.assertEquals((String)"${my.prop}", (String)((String)this.buildConfig("expression", "\\${my.prop}").getValue("expression", String.class)));
    }

    @Test
    void arrayEscapes() {
        Config config = this.buildConfig("list", "cat,dog,${mouse},sea\\,turtle", "mouse", "mouse");
        List list = config.getValues("list", String.class);
        Assert.assertEquals((int)4, (int)list.size());
        Assert.assertEquals((Collection)list, (Collection)Stream.of("cat", "dog", "mouse", "sea,turtle").collect(Collectors.toList()));
    }

    @Test
    void escapeBraces() {
        Config config = this.buildConfig("my.prop", "${value:111{111}");
        Assert.assertEquals((String)"111{111", (String)((String)config.getValue("my.prop", String.class)));
    }

    @Test
    void expressionMissing() {
        Config config = this.buildConfig("my.prop", "${expression}", "my.prop.partial", "${expression}partial");
        Assert.assertThrows(Exception.class, () -> {
            String cfr_ignored_0 = (String)config.getValue("my.prop", String.class);
        });
        Assert.assertThrows(Exception.class, () -> {
            String cfr_ignored_0 = (String)config.getValue("my.prop.partial", String.class);
        });
    }

    private Config buildConfig(String ... keyValues) {
        if (keyValues.length % 2 != 0) {
            throw new IllegalArgumentException("keyValues array must be a multiple of 2");
        }
        final HashMap<String, String> properties = new HashMap<String, String>();
        for (int i = 0; i < keyValues.length; i += 2) {
            properties.put(keyValues[i], keyValues[i + 1]);
        }
        Config result = ConfigProviderResolver.instance().getBuilder().withSources(new ConfigSource[]{new ConfigSource(){

            public Set<String> getPropertyNames() {
                return properties.keySet();
            }

            public String getValue(String propertyName) {
                return (String)properties.get(propertyName);
            }

            public String getName() {
                return "test";
            }
        }}).build();
        this.builtConfigs.add(result);
        return result;
    }
}

