/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.wtp.internal.facets;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.m2e.wtp.WTPProjectsUtil;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;
import org.eclipse.wst.common.project.facet.core.IDelegate;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EarVersionChangeDelegate
implements IDelegate {
    private static final Logger LOG = LoggerFactory.getLogger(EarVersionChangeDelegate.class);

    public void execute(IProject project, IProjectFacetVersion fv, Object cfg, IProgressMonitor monitor) throws CoreException {
        if (cfg == null) {
            return;
        }
        if (monitor != null) {
            monitor.beginTask("Updating EAR facet version", 1);
        }
        try {
            if (project.hasNature("org.eclipse.m2e.core.maven2Nature")) {
                IDataModel model = (IDataModel)cfg;
                if (monitor != null) {
                    monitor.worked(1);
                }
                if (model.isProperty("IEarFacetInstallDataModelProperties.CONTENT_DIR")) {
                    Path earContent = new Path("/" + model.getStringProperty("IEarFacetInstallDataModelProperties.CONTENT_DIR"));
                    IVirtualComponent c = ComponentCore.createComponent((IProject)project, (boolean)true);
                    if (c != null) {
                        IVirtualFolder earroot = c.getRootFolder();
                        if (!WTPProjectsUtil.hasLink(project, (IPath)new Path("/"), (IPath)earContent, monitor)) {
                            earroot.createLink((IPath)earContent, 0, null);
                        }
                        WTPProjectsUtil.setDefaultDeploymentDescriptorFolder(earroot, (IPath)earContent, monitor);
                    }
                    try {
                        ((IDataModelOperation)model.getProperty("FacetDataModelProvider.NOTIFICATION_OPERATION")).execute(monitor, null);
                    }
                    catch (ExecutionException e) {
                        LOG.error("Unable to notify EAR version change", (Throwable)e);
                    }
                }
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }
}

