/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.internal.core;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.lsp4mp.jdt.internal.core.StaticPropertyProvider;

public class StaticPropertyProviderRegistry
implements IRegistryChangeListener {
    private static final String ENABLED_WHEN_ELT = "enabledWhen";
    private static final String TYPE_ON_CLASSPATH_ELT = "typeOnClasspath";
    private static final String RESOURCE_ATTR = "resource";
    private static final String TYPE_ATTR = "type";
    private static final Logger LOGGER = Logger.getLogger(StaticPropertyProviderRegistry.class.getName());
    private boolean extensionProvidersLoaded = false;
    private boolean registryListenerIntialized = false;
    private final List<StaticPropertyProvider> providers = new ArrayList<StaticPropertyProvider>();
    private static final StaticPropertyProviderRegistry INSTANCE = new StaticPropertyProviderRegistry();

    public static StaticPropertyProviderRegistry getInstance() {
        return INSTANCE;
    }

    public String getProviderExtensionId() {
        return "staticPropertyProviders";
    }

    public List<StaticPropertyProvider> getProviders() {
        this.loadExtensionProviders();
        return this.providers;
    }

    public synchronized void loadExtensionProviders() {
        if (this.extensionProvidersLoaded) {
            return;
        }
        this.extensionProvidersLoaded = true;
        LOGGER.log(Level.INFO, "->- Loading ." + this.getProviderExtensionId() + " extension point ->-");
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor("org.eclipse.lsp4mp.jdt.core", this.getProviderExtensionId());
        this.addExtensionStaticProperty(cf);
        this.addRegistryListenerIfNeeded();
        LOGGER.log(Level.INFO, "-<- Done loading ." + this.getProviderExtensionId() + " extension point -<-");
    }

    private void addExtensionStaticProperty(IConfigurationElement[] cf) {
        IConfigurationElement[] iConfigurationElementArray = cf;
        int n = cf.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ce = iConfigurationElementArray[n2];
            String resource = ce.getAttribute(RESOURCE_ATTR);
            StaticPropertyProvider staticPropertyProvider = new StaticPropertyProvider(resource);
            IConfigurationElement[] iConfigurationElementArray2 = ce.getChildren(ENABLED_WHEN_ELT);
            int n3 = iConfigurationElementArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement enabledWhenElement = iConfigurationElementArray2[n4];
                IConfigurationElement[] iConfigurationElementArray3 = enabledWhenElement.getChildren(TYPE_ON_CLASSPATH_ELT);
                int n5 = iConfigurationElementArray3.length;
                int n6 = 0;
                while (n6 < n5) {
                    IConfigurationElement typeOnClasspathElement = iConfigurationElementArray3[n6];
                    staticPropertyProvider.setType(typeOnClasspathElement.getAttribute(TYPE_ATTR));
                    ++n6;
                }
                ++n4;
            }
            this.providers.add(staticPropertyProvider);
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registryChanged(IRegistryChangeEvent event) {
        IExtensionDelta[] deltas = event.getExtensionDeltas("org.eclipse.lsp4mp.jdt.core", this.getProviderExtensionId());
        if (deltas != null) {
            StaticPropertyProviderRegistry staticPropertyProviderRegistry = this;
            synchronized (staticPropertyProviderRegistry) {
                IExtensionDelta[] iExtensionDeltaArray = deltas;
                int n = deltas.length;
                int n2 = 0;
                while (n2 < n) {
                    IExtensionDelta delta = iExtensionDeltaArray[n2];
                    IConfigurationElement[] cf = delta.getExtension().getConfigurationElements();
                    if (delta.getKind() == 1) {
                        this.addExtensionStaticProperty(cf);
                    }
                    ++n2;
                }
            }
        }
    }

    private void addRegistryListenerIfNeeded() {
        if (this.registryListenerIntialized) {
            return;
        }
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        registry.addRegistryChangeListener((IRegistryChangeListener)this, "org.eclipse.lsp4mp.jdt.core");
        this.registryListenerIntialized = true;
    }
}

