/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.internal.core;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.Platform;

public abstract class AbstractMicroProfileProviderRegistry<T>
implements IRegistryChangeListener {
    private static final String CLASS_ATTR = "class";
    private static final Logger LOGGER = Logger.getLogger(AbstractMicroProfileProviderRegistry.class.getName());
    private boolean extensionProvidersLoaded = false;
    private boolean registryListenerIntialized = false;
    private final List<T> providers = new ArrayList<T>();

    public abstract String getProviderExtensionId();

    public List<T> getProviders() {
        this.loadExtensionProviders();
        return this.providers;
    }

    private synchronized void loadExtensionProviders() {
        if (this.extensionProvidersLoaded) {
            return;
        }
        this.extensionProvidersLoaded = true;
        LOGGER.log(Level.INFO, "->- Loading ." + this.getProviderExtensionId() + " extension point ->-");
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor("org.eclipse.lsp4mp.jdt.core", this.getProviderExtensionId());
        this.addExtensionProviders(cf);
        this.addRegistryListenerIfNeeded();
        LOGGER.log(Level.INFO, "-<- Done loading ." + this.getProviderExtensionId() + " extension point -<-");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registryChanged(IRegistryChangeEvent event) {
        IExtensionDelta[] deltas = event.getExtensionDeltas("org.eclipse.lsp4mp.jdt.core", this.getProviderExtensionId());
        if (deltas != null) {
            AbstractMicroProfileProviderRegistry abstractMicroProfileProviderRegistry = this;
            synchronized (abstractMicroProfileProviderRegistry) {
                IExtensionDelta[] iExtensionDeltaArray = deltas;
                int n = deltas.length;
                int n2 = 0;
                while (n2 < n) {
                    IExtensionDelta delta = iExtensionDeltaArray[n2];
                    IConfigurationElement[] cf = delta.getExtension().getConfigurationElements();
                    if (delta.getKind() == 1) {
                        this.addExtensionProviders(cf);
                    } else {
                        this.removeExtensionProviders(cf);
                    }
                    ++n2;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addExtensionProviders(IConfigurationElement[] cf) {
        IConfigurationElement[] iConfigurationElementArray = cf;
        int n = cf.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ce = iConfigurationElementArray[n2];
            try {
                Object provider = ce.createExecutableExtension(CLASS_ATTR);
                List<T> list = this.providers;
                synchronized (list) {
                    this.providers.add(provider);
                }
                LOGGER.log(Level.INFO, "  Loaded " + this.getProviderExtensionId() + ": " + provider.getClass().getName());
            }
            catch (Throwable t) {
                LOGGER.log(Level.SEVERE, "  Loaded while loading " + this.getProviderExtensionId(), t);
            }
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeExtensionProviders(IConfigurationElement[] cf) {
        IConfigurationElement[] iConfigurationElementArray = cf;
        int n = cf.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ce = iConfigurationElementArray[n2];
            try {
                Object provider = ce.createExecutableExtension(CLASS_ATTR);
                List<T> list = this.providers;
                synchronized (list) {
                    this.providers.remove(provider);
                }
                LOGGER.log(Level.INFO, "  Unloaded " + this.getProviderExtensionId() + ": " + provider.getClass().getName());
            }
            catch (Throwable t) {
                LOGGER.log(Level.SEVERE, "  Unloaded while loading " + this.getProviderExtensionId(), t);
            }
            ++n2;
        }
    }

    private void addRegistryListenerIfNeeded() {
        if (this.registryListenerIntialized) {
            return;
        }
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        registry.addRegistryChangeListener((IRegistryChangeListener)this, "org.eclipse.lsp4mp.jdt.core");
        this.registryListenerIntialized = true;
    }

    public void destroy() {
        Platform.getExtensionRegistry().removeRegistryChangeListener((IRegistryChangeListener)this);
    }

    public void initialize() {
    }
}

