/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.edit;

import java.io.File;
import java.net.URI;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServers;
import org.eclipse.lsp4e.test.utils.AbstractTestWithProject;
import org.eclipse.lsp4e.test.utils.TestUtils;
import org.eclipse.lsp4e.tests.mock.MockLanguageServer;
import org.eclipse.lsp4e.ui.UI;
import org.eclipse.lsp4j.DidSaveTextDocumentParams;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.ide.IDE;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DocumentDidSaveTest
extends AbstractTestWithProject {
    @Test
    public void testSave() throws Exception {
        IFile testFile = TestUtils.createUniqueTestFile(this.project, "");
        IEditorPart editor = TestUtils.openEditor(testFile);
        ITextViewer viewer = LSPEclipseUtils.getTextViewer((IEditorPart)editor);
        testFile.setLocalTimeStamp(0L);
        IDocument document = LSPEclipseUtils.getDocument((IResource)testFile);
        Assertions.assertNotNull((Object)document);
        LanguageServers.forDocument((IDocument)document).anyMatching();
        CompletableFuture didSaveExpectation = new CompletableFuture();
        MockLanguageServer.INSTANCE.setDidSaveCallback(didSaveExpectation);
        viewer.getDocument().replace(0, 0, "Hello");
        editor.doSave((IProgressMonitor)new NullProgressMonitor());
        TestUtils.waitForAndAssertCondition(2000, () -> {
            DidSaveTextDocumentParams lastChange = (DidSaveTextDocumentParams)didSaveExpectation.get(10L, TimeUnit.MILLISECONDS);
            Assertions.assertNotNull((Object)lastChange.getTextDocument());
            Assertions.assertEquals((Object)LSPEclipseUtils.toUri((IResource)testFile).toString(), (Object)lastChange.getTextDocument().getUri());
            return true;
        });
    }

    @Test
    public void testSaveExternalFile() throws Exception {
        File file = TestUtils.createTempFile("testSaveExternalFile", ".lspt");
        IEditorPart editor = IDE.openEditorOnFileStore((IWorkbenchPage)UI.getActivePage(), (IFileStore)EFS.getStore((URI)file.toURI()));
        ITextViewer viewer = LSPEclipseUtils.getTextViewer((IEditorPart)editor);
        LanguageServers.forDocument((IDocument)LSPEclipseUtils.getDocument((IEditorInput)editor.getEditorInput())).anyMatching();
        CompletableFuture didSaveExpectation = new CompletableFuture();
        MockLanguageServer.INSTANCE.setDidSaveCallback(didSaveExpectation);
        viewer.getDocument().replace(0, 0, "Hello");
        editor.doSave((IProgressMonitor)new NullProgressMonitor());
        TestUtils.waitForAndAssertCondition(2000, () -> {
            DidSaveTextDocumentParams lastChange = (DidSaveTextDocumentParams)didSaveExpectation.get(10L, TimeUnit.MILLISECONDS);
            Assertions.assertNotNull((Object)lastChange.getTextDocument());
            Assertions.assertEquals((Object)LSPEclipseUtils.toUri((File)file).toString(), (Object)lastChange.getTextDocument().getUri());
            return true;
        });
    }
}

