/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.outline;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.lsp4e.LanguageServerWrapper;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4e.outline.CNFOutlinePage;
import org.eclipse.lsp4e.outline.EditorToOutlineAdapterFactory;
import org.eclipse.lsp4e.outline.SymbolsModel;
import org.eclipse.lsp4e.test.utils.AbstractTestWithProject;
import org.eclipse.lsp4e.test.utils.TestUtils;
import org.eclipse.lsp4e.tests.mock.MockLanguageServer;
import org.eclipse.lsp4j.DocumentSymbol;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.SymbolKind;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.tests.harness.util.DisplayHelper;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.junit.Assert;
import org.junit.Test;

public class OutlineContentTest
extends AbstractTestWithProject {
    @Test
    public void testExternalFile() throws CoreException, IOException {
        File testFile = TestUtils.createTempFile("test" + System.currentTimeMillis(), ".lspt");
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileWriter fileWriter = new FileWriter(testFile);){
            fileWriter.write("content\n does\n not\n matter\n but needs to cover the ranges described below");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        DocumentSymbol symbolCow = new DocumentSymbol("cow", SymbolKind.Constant, new Range(new Position(0, 0), new Position(0, 2)), new Range(new Position(0, 0), new Position(0, 2)));
        MockLanguageServer.INSTANCE.setDocumentSymbols(symbolCow);
        ITextEditor editor = (ITextEditor)TestUtils.openExternalFileInEditor(testFile);
        CNFOutlinePage outlinePage = (CNFOutlinePage)new EditorToOutlineAdapterFactory().getAdapter((Object)editor, IContentOutlinePage.class);
        Shell shell = new Shell(editor.getEditorSite().getWorkbenchWindow().getShell());
        shell.setLayout((Layout)new FillLayout());
        outlinePage.createControl((Composite)shell);
        shell.open();
        Tree tree = (Tree)outlinePage.getControl();
        TestUtils.waitForAndAssertCondition(5000, tree.getDisplay(), () -> Arrays.asList(symbolCow).equals(Arrays.stream(tree.getItems()).map(e -> ((SymbolsModel.DocumentSymbolWithURI)e.getData()).symbol).toList()));
        shell.close();
    }

    @Test
    public void testOutlineSorting() throws CoreException, IOException {
        IFile testFile = TestUtils.createUniqueTestFile(this.project, "content\n does\n not\n matter\n but needs to cover the ranges described below");
        DocumentSymbol symbolCow = new DocumentSymbol("cow", SymbolKind.Constant, new Range(new Position(0, 0), new Position(0, 2)), new Range(new Position(0, 0), new Position(0, 2)));
        DocumentSymbol symbolFox = new DocumentSymbol("fox", SymbolKind.Constant, new Range(new Position(1, 0), new Position(1, 2)), new Range(new Position(1, 0), new Position(1, 2)));
        DocumentSymbol symbolCat = new DocumentSymbol("cat", SymbolKind.Constant, new Range(new Position(2, 0), new Position(2, 2)), new Range(new Position(2, 0), new Position(2, 2)));
        MockLanguageServer.INSTANCE.setDocumentSymbols(new DocumentSymbol[]{symbolCow, symbolFox, symbolCat});
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.eclipse.lsp4e");
        prefs.putBoolean("org.eclipse.lsp4e.outline.sortOutline", false);
        ITextEditor editor = (ITextEditor)TestUtils.openEditor(testFile);
        LanguageServerWrapper wrapper = (LanguageServerWrapper)LanguageServiceAccessor.getLSWrappers((IFile)testFile, request -> true).iterator().next();
        CNFOutlinePage outlinePage = new CNFOutlinePage(wrapper, editor);
        Shell shell = new Shell(editor.getEditorSite().getWorkbenchWindow().getShell());
        shell.setLayout((Layout)new FillLayout());
        outlinePage.createControl((Composite)shell);
        shell.open();
        Tree tree = (Tree)outlinePage.getControl();
        TestUtils.waitForAndAssertCondition(5000, tree.getDisplay(), () -> Arrays.asList(symbolCow, symbolFox, symbolCat).equals(Arrays.stream(tree.getItems()).map(e -> ((SymbolsModel.DocumentSymbolWithURI)e.getData()).symbol).toList()));
        prefs.putBoolean("org.eclipse.lsp4e.outline.sortOutline", true);
        TestUtils.waitForAndAssertCondition(5000, tree.getDisplay(), () -> Arrays.asList(symbolCat, symbolCow, symbolFox).equals(Arrays.stream(tree.getItems()).map(e -> ((SymbolsModel.DocumentSymbolWithURI)e.getData()).symbol).toList()));
        shell.close();
    }

    @Test
    public void testNodeRemainExpandedUponSelection() throws CoreException, IOException {
        IFile testFile = TestUtils.createUniqueTestFile(this.project, "a(b())");
        MockLanguageServer.INSTANCE.setDocumentSymbols(new DocumentSymbol("a", SymbolKind.Constant, new Range(new Position(0, 0), new Position(0, 6)), new Range(new Position(0, 0), new Position(0, 1)), "", Collections.singletonList(new DocumentSymbol("b", SymbolKind.Constant, new Range(new Position(0, 2), new Position(0, 5)), new Range(new Position(0, 2), new Position(0, 3))))));
        ITextEditor editor = (ITextEditor)TestUtils.openEditor(testFile);
        LanguageServerWrapper wrapper = (LanguageServerWrapper)LanguageServiceAccessor.getLSWrappers((IFile)testFile, request -> true).iterator().next();
        CNFOutlinePage outlinePage = new CNFOutlinePage(wrapper, editor);
        Shell shell = new Shell(editor.getEditorSite().getWorkbenchWindow().getShell());
        shell.setLayout((Layout)new FillLayout());
        outlinePage.createControl((Composite)shell);
        shell.open();
        Tree tree = (Tree)outlinePage.getControl();
        DisplayHelper.sleep((Display)tree.getDisplay(), (long)500L);
        editor.getSelectionProvider().setSelection((ISelection)new TextSelection(4, 0));
        TestUtils.waitForAndAssertCondition(2000, tree.getDisplay(), () -> this.itemBselectedAndVisibile(tree));
        editor.getSelectionProvider().setSelection((ISelection)new TextSelection(3, 0));
        Assert.assertFalse((boolean)TestUtils.waitForCondition(2000, tree.getDisplay(), () -> !this.itemBselectedAndVisibile(tree)));
        shell.close();
    }

    @Test
    public void testNodeRemainExpandedUponModification() throws CoreException, BadLocationException, IOException {
        IFile testFile = TestUtils.createUniqueTestFile(this.project, "a(b())");
        MockLanguageServer.INSTANCE.setDocumentSymbols(new DocumentSymbol("a", SymbolKind.Constant, new Range(new Position(0, 0), new Position(0, 6)), new Range(new Position(0, 0), new Position(0, 1)), "", Collections.singletonList(new DocumentSymbol("b", SymbolKind.Constant, new Range(new Position(0, 2), new Position(0, 5)), new Range(new Position(0, 2), new Position(0, 3))))));
        ITextEditor editor = (ITextEditor)TestUtils.openEditor(testFile);
        LanguageServerWrapper wrapper = (LanguageServerWrapper)LanguageServiceAccessor.getLSWrappers((IFile)testFile, request -> true).iterator().next();
        CNFOutlinePage outlinePage = new CNFOutlinePage(wrapper, editor);
        Shell shell = new Shell(editor.getEditorSite().getWorkbenchWindow().getShell());
        shell.setLayout((Layout)new FillLayout());
        outlinePage.createControl((Composite)shell);
        shell.open();
        Tree tree = (Tree)outlinePage.getControl();
        DisplayHelper.sleep((Display)tree.getDisplay(), (long)500L);
        editor.getSelectionProvider().setSelection((ISelection)new TextSelection(4, 0));
        TestUtils.waitForAndAssertCondition(2000, tree.getDisplay(), () -> tree.getItems().length > 0 && tree.getItem(0).getExpanded());
        IDocument document = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
        editor.selectAndReveal(document.getLength(), 0);
        document.replace(document.getLength(), 0, "   ");
        Assert.assertFalse((boolean)TestUtils.waitForCondition(2000, tree.getDisplay(), () -> !tree.getItem(0).getExpanded()));
        shell.close();
    }

    private boolean itemBselectedAndVisibile(Tree tree) {
        if (tree.getSelection().length == 0) {
            return false;
        }
        TreeItem selection = tree.getSelection()[0];
        return selection != null && selection.getText().equals("b") && selection.getParentItem().getExpanded();
    }
}

