/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.references;

import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.lsp4e.internal.Pair;
import org.eclipse.lsp4e.operations.references.LSFindReferences;
import org.eclipse.lsp4e.operations.references.LSSearchResult;
import org.eclipse.lsp4e.test.utils.AllCleanRule;
import org.eclipse.lsp4e.test.utils.TestUtils;
import org.eclipse.lsp4e.tests.mock.MockLanguageServer;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.search.internal.ui.text.FileMatch;
import org.eclipse.search.ui.IQueryListener;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.ISearchResultViewPart;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.search.ui.text.Match;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.monitoring.EventLoopMonitorThread;
import org.eclipse.ui.monitoring.IUiFreezeEventLogger;
import org.eclipse.ui.monitoring.UiFreezeEvent;
import org.eclipse.ui.services.IEvaluationService;
import org.eclipse.ui.tests.harness.util.DisplayHelper;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class FindReferencesTest {
    @Rule
    public AllCleanRule clear = new AllCleanRule();
    private IProject project;

    @Before
    public void setUp() throws CoreException {
        this.project = TestUtils.createProject("CompletionTest" + System.currentTimeMillis());
        this.ensureSearchResultViewIsClosed();
        IFile testFile = TestUtils.createUniqueTestFile(this.project, "word1 word2\nword3 word2");
        ITextViewer textViewer = TestUtils.openTextViewer(testFile);
        DisplayHelper.sleep((Display)textViewer.getTextWidget().getDisplay(), (long)2000L);
        MockLanguageServer.INSTANCE.getTextDocumentService().setMockReferences(new Location[]{new Location(testFile.getLocationURI().toString(), new Range(new Position(0, 6), new Position(0, 11))), new Location(testFile.getLocationURI().toString(), new Range(new Position(1, 6), new Position(1, 11)))});
    }

    @After
    public void tearDown() {
        this.ensureSearchResultViewIsClosed();
    }

    @Test
    public void testFindReferences() throws Exception {
        LSFindReferences handler = new LSFindReferences();
        IEvaluationService evaluationService = (IEvaluationService)PlatformUI.getWorkbench().getService(IEvaluationService.class);
        CompletableFuture<Pair<ISearchResult, Long>> searchResultListener = this.registerSearchResultListener();
        handler.execute(new ExecutionEvent(null, new HashMap(), null, (Object)evaluationService.getCurrentState()));
        this.waitForAndAssertSearchResult(searchResultListener, 0, 2000);
    }

    @Test
    public void testFindReferencesIsNonBlocking() throws Exception {
        int uiFreezeThreshold = 300;
        int findReferencesFakeDuration = 1500;
        Assert.assertNull((Object)UiFreezeEventLogger.INSTANCE);
        EventLoopMonitorThread uiFreezeMonitor = this.initFreezeMonitor(300);
        TestUtils.waitForAndAssertCondition("UiFreezeEventLogger.INSTANCE is null", 2000, () -> UiFreezeEventLogger.INSTANCE != null);
        MockLanguageServer.INSTANCE.setTimeToProceedQueries(1500L);
        try {
            LSFindReferences handler = new LSFindReferences();
            IEvaluationService evaluationService = (IEvaluationService)PlatformUI.getWorkbench().getService(IEvaluationService.class);
            CompletableFuture<Pair<ISearchResult, Long>> searchResultListener = this.registerSearchResultListener();
            long startTime = System.currentTimeMillis();
            handler.execute(new ExecutionEvent(null, new HashMap(), null, (Object)evaluationService.getCurrentState()));
            long executionTime = System.currentTimeMillis() - startTime;
            Assert.assertTrue((String)(handler.getClass().getSimpleName() + ".execute(...) blocks UI for " + executionTime + "ms. Acceptable is <300ms"), (executionTime < 300L ? 1 : 0) != 0);
            this.waitForAndAssertSearchResult(searchResultListener, 1500, 2500);
        }
        finally {
            MockLanguageServer.INSTANCE.setTimeToProceedQueries(0L);
            uiFreezeMonitor.shutdown();
        }
        int uiFreezeCount = UiFreezeEventLogger.INSTANCE.events.size();
        Assert.assertEquals((String)("UI Thread was frozen " + uiFreezeCount + " times for more than 300ms"), (long)0L, (long)uiFreezeCount);
    }

    private EventLoopMonitorThread initFreezeMonitor(int uiFreezeThreshold) {
        EventLoopMonitorThread.Parameters args = new EventLoopMonitorThread.Parameters();
        args.longEventWarningThreshold = uiFreezeThreshold;
        args.longEventErrorThreshold = uiFreezeThreshold;
        args.deadlockThreshold = 30000L;
        args.uiThreadFilter = "";
        args.noninterestingThreadFilter = "sun.*,java.*,jdk.internal.*";
        EventLoopMonitorThread monitor = new EventLoopMonitorThread(args);
        monitor.start();
        return monitor;
    }

    private void ensureSearchResultViewIsClosed() {
        ISearchResultViewPart searchPart = NewSearchUI.getSearchResultView();
        if (searchPart != null) {
            searchPart.getViewSite().getPage().hideView((IViewPart)searchPart);
        }
    }

    private CompletableFuture<Pair<ISearchResult, Long>> registerSearchResultListener() {
        final CompletableFuture<Pair<ISearchResult, Long>> future = new CompletableFuture<Pair<ISearchResult, Long>>();
        final HashMap startTimes = new HashMap();
        NewSearchUI.addQueryListener((IQueryListener)new IQueryListener(){

            public void queryAdded(ISearchQuery q) {
            }

            public void queryRemoved(ISearchQuery q) {
            }

            public void queryStarting(ISearchQuery q) {
                startTimes.put(q, System.currentTimeMillis());
            }

            public void queryFinished(ISearchQuery q) {
                future.complete(Pair.of((Object)q.getSearchResult(), (Object)(System.currentTimeMillis() - (Long)startTimes.get(q))));
            }
        });
        return future;
    }

    private void waitForAndAssertSearchResult(CompletableFuture<Pair<ISearchResult, Long>> searchResultListener, int min_time_ms, int max_time_ms) {
        long startAt = System.currentTimeMillis();
        AtomicLong searchDuration = new AtomicLong(-1L);
        TestUtils.waitForAndAssertCondition(max_time_ms, () -> {
            Pair searchResult = searchResultListener.getNow(null);
            Assert.assertNotNull((String)"No search query was executed", (Object)searchResult);
            Object object = searchResult.getFirst();
            if (object instanceof LSSearchResult) {
                LSSearchResult lsSearchResult = (LSSearchResult)object;
                long now = System.currentTimeMillis();
                Assert.assertEquals((long)2L, (long)lsSearchResult.getMatchCount());
                Object file = lsSearchResult.getElements()[0];
                Match match1 = lsSearchResult.getMatches(file)[0];
                Assert.assertEquals((long)6L, (long)match1.getOffset());
                Assert.assertEquals((long)5L, (long)match1.getLength());
                if (match1 instanceof FileMatch) {
                    FileMatch fileMatch = (FileMatch)match1;
                    Assert.assertEquals((long)1L, (long)fileMatch.getLineElement().getLine());
                }
                Match match2 = lsSearchResult.getMatches(file)[1];
                Assert.assertEquals((long)18L, (long)match2.getOffset());
                Assert.assertEquals((long)5L, (long)match2.getLength());
                if (match2 instanceof FileMatch) {
                    FileMatch fileMatch = (FileMatch)match2;
                    Assert.assertEquals((long)2L, (long)fileMatch.getLineElement().getLine());
                }
                if (searchDuration.get() < 0L) {
                    searchDuration.set(now - startAt);
                }
                Assert.assertTrue((String)"Search result returned too early!", (searchDuration.get() >= (long)min_time_ms ? 1 : 0) != 0);
                Assert.assertNotNull((String)"Search result view is not shown", (Object)NewSearchUI.getSearchResultView());
            } else {
                Assert.fail((String)("Search result " + String.valueOf(searchResult) + " is not of expected type LSSearchResult"));
            }
            return true;
        });
    }

    public static final class UiFreezeEventLogger
    implements IUiFreezeEventLogger {
        static volatile UiFreezeEventLogger INSTANCE;
        final List<UiFreezeEvent> events = new Vector<UiFreezeEvent>();

        public UiFreezeEventLogger() {
            INSTANCE = this;
        }

        public void log(UiFreezeEvent event) {
            System.err.println(event);
            this.events.add(event);
        }
    }
}

