/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.lsp4e.LanguageServerWrapper;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4e.test.utils.AllCleanRule;
import org.eclipse.lsp4e.test.utils.MockConnectionProviderWithStartException;
import org.eclipse.lsp4e.test.utils.TestUtils;
import org.eclipse.ui.IEditorPart;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class LanguageServerWrapperTest {
    private IProject project1;
    private IProject project2;
    @Rule
    public AllCleanRule clear = new AllCleanRule();

    @Before
    public void setUp() throws CoreException {
        this.project1 = TestUtils.createProject("LanguageServerWrapperTestProject1" + System.currentTimeMillis());
        this.project2 = TestUtils.createProject("LanguageServerWrapperTestProject2" + System.currentTimeMillis());
    }

    @Test
    public void testConnect() throws Exception {
        IFile testFile1 = TestUtils.createFile(this.project1, "shouldUseExtension.lsptWithMultiRoot", "");
        IFile testFile2 = TestUtils.createFile(this.project2, "shouldUseExtension.lsptWithMultiRoot", "");
        IEditorPart editor1 = TestUtils.openEditor(testFile1);
        IEditorPart editor2 = TestUtils.openEditor(testFile2);
        @NonNull List wrappers = LanguageServiceAccessor.getLSWrappers((IFile)testFile1, request -> true);
        Assert.assertEquals((long)1L, (long)wrappers.size());
        LanguageServerWrapper wrapper = (LanguageServerWrapper)wrappers.iterator().next();
        TestUtils.waitForAndAssertCondition(2000, () -> wrapper.isActive());
        Assert.assertTrue((boolean)wrapper.toString().matches("LanguageServerWrapper@[0-9a-f]+ \\[serverId=org.eclipse.lsp4e.test.server-with-multi-root-support, initialPath=null, initialProject=P\\/LanguageServerWrapperTestProject1[0-9]+, isActive=true, pid=(null|[0-9])+\\]"));
        Assert.assertTrue((boolean)wrapper.isConnectedTo(testFile1.getLocationURI()));
        Assert.assertTrue((boolean)wrapper.isConnectedTo(testFile2.getLocationURI()));
        TestUtils.closeEditor(editor1, false);
        TestUtils.closeEditor(editor2, false);
    }

    @Test
    public void testStopAndActive() throws CoreException, IOException, AssertionError, InterruptedException, ExecutionException {
        IFile testFile1 = TestUtils.createFile(this.project1, "shouldUseExtension.lsptWithMultiRoot", "");
        IEditorPart editor1 = TestUtils.openEditor(testFile1);
        @NonNull List wrappers = LanguageServiceAccessor.getLSWrappers((IFile)testFile1, request -> true);
        Assert.assertEquals((long)1L, (long)wrappers.size());
        LanguageServerWrapper wrapper = (LanguageServerWrapper)wrappers.iterator().next();
        CountDownLatch started = new CountDownLatch(1);
        try {
            Future startStopJob = ForkJoinPool.commonPool().submit(() -> {
                started.countDown();
                while (!Thread.interrupted()) {
                    wrapper.stop();
                    try {
                        wrapper.start();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
            try {
                started.await();
                int i = 0;
                while (i < 10000000) {
                    wrapper.isActive();
                    if (((ForkJoinTask)startStopJob).isDone()) {
                        throw new AssertionError((Object)"Job should run indefinitely");
                    }
                    ++i;
                }
            }
            finally {
                ((ForkJoinTask)startStopJob).cancel(true);
                if (!((ForkJoinTask)startStopJob).isCancelled()) {
                    ((ForkJoinTask)startStopJob).get();
                }
            }
        }
        finally {
            TestUtils.closeEditor(editor1, false);
        }
    }

    @Test
    public void testStartExceptionRace() throws Exception {
        IFile testFile1 = TestUtils.createFile(this.project1, "shouldUseExtension.lsptStartException", "");
        IEditorPart editor1 = TestUtils.openEditor(testFile1);
        MockConnectionProviderWithStartException.resetCounters();
        int RUNS = 10;
        int i = 0;
        while (i < 10) {
            MockConnectionProviderWithStartException.resetStartFuture();
            @NonNull List wrappers = LanguageServiceAccessor.getLSWrappers((IFile)testFile1, request -> true);
            try {
                MockConnectionProviderWithStartException.waitForStart();
            }
            catch (TimeoutException e) {
                throw new RuntimeException("Start #" + i + " was not called", e);
            }
            Assert.assertEquals((long)1L, (long)wrappers.size());
            LanguageServerWrapper wrapper = (LanguageServerWrapper)wrappers.iterator().next();
            Assert.assertTrue((!wrapper.isActive() ? 1 : 0) != 0);
            Assert.assertTrue((MockConnectionProviderWithStartException.getStartCounter() >= i ? 1 : 0) != 0);
            ++i;
        }
        TestUtils.waitForAndAssertCondition(2000, () -> MockConnectionProviderWithStartException.getStopCounter() >= 10);
        TestUtils.closeEditor(editor1, false);
    }
}

