/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test;

import java.util.List;
import org.eclipse.lsp4e.ContentTypeToLanguageServerDefinition;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServersRegistry;
import org.eclipse.lsp4e.test.utils.TestUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class ContentTypeToLanguageServerDefinitionTest {
    public static final String SERVER_TO_DISABLE = "org.eclipse.lsp4e.test.server.disable";
    public static final String DISABLED_CONTENT_TYPE = "org.eclipse.lsp4e.test.content-type-disabled";
    public static final String DISABLED_SERVER_PREF = "org.eclipse.lsp4e.test.server.disable/org.eclipse.lsp4e.test.content-type-disabled";

    @BeforeClass
    public static void setup() {
        LanguageServerPlugin.getDefault().getPreferenceStore().setValue(DISABLED_SERVER_PREF, "false");
    }

    @AfterClass
    public static void cleanup() {
        TestUtils.getDisabledLS().setUserEnabled(false);
    }

    @Test
    public void testDisabledLanguageServerMappingsPreference() {
        List<ContentTypeToLanguageServerDefinition> disabledDefinitions = LanguageServersRegistry.getInstance().getContentTypeToLSPExtensions().stream().filter(lsDefinition -> !lsDefinition.isEnabled(null)).toList();
        Assert.assertTrue((boolean)disabledDefinitions.contains(TestUtils.getDisabledLS()));
    }

    @Test
    public void testDisableLanguageServerMapping() {
        ContentTypeToLanguageServerDefinition lsDefinition = TestUtils.getDisabledLS();
        lsDefinition.setUserEnabled(false);
        Assert.assertFalse((boolean)lsDefinition.isEnabled(null));
        Assert.assertTrue((boolean)LanguageServerPlugin.getDefault().getPreferenceStore().contains(DISABLED_SERVER_PREF));
        Assert.assertFalse((boolean)LanguageServerPlugin.getDefault().getPreferenceStore().getBoolean(DISABLED_SERVER_PREF));
        lsDefinition.setUserEnabled(true);
        Assert.assertTrue((boolean)lsDefinition.isEnabled(null));
        Assert.assertTrue((boolean)LanguageServerPlugin.getDefault().getPreferenceStore().contains(DISABLED_SERVER_PREF));
        Assert.assertTrue((boolean)LanguageServerPlugin.getDefault().getPreferenceStore().getBoolean(DISABLED_SERVER_PREF));
    }
}

