/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.selectionRange;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServers;
import org.eclipse.lsp4e.internal.LSPDocumentAbstractHandler;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.SelectionRange;
import org.eclipse.lsp4j.SelectionRangeParams;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.swt.custom.CaretEvent;
import org.eclipse.swt.custom.CaretListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.ui.texteditor.ITextEditor;

public abstract class LSPSelectionRangeAbstractHandler
extends LSPDocumentAbstractHandler {
    /*
     * WARNING - void declaration
     */
    @Override
    protected void execute(ExecutionEvent event, ITextEditor textEditor) {
        ISelectionProvider provider = textEditor.getSelectionProvider();
        if (provider == null) {
            return;
        }
        ISelection sel = provider.getSelection();
        ITextViewer viewer = (ITextViewer)textEditor.getAdapter(ITextViewer.class);
        if (viewer == null) {
            return;
        }
        StyledText styledText = viewer.getTextWidget();
        if (styledText == null) {
            return;
        }
        ISelection iSelection = sel;
        if (iSelection instanceof ITextSelection) {
            LanguageServers.LanguageServerDocumentExecutor executor;
            IDocument document;
            void textSelection;
            ITextSelection iTextSelection = (ITextSelection)iSelection;
            ITextSelection cfr_ignored_0 = (ITextSelection)iSelection;
            if (!textSelection.isEmpty() && (document = LSPEclipseUtils.getDocument(textEditor)) != null && (executor = (LanguageServers.LanguageServerDocumentExecutor)LanguageServers.forDocument(document).withCapability(ServerCapabilities::getSelectionRangeProvider)).anyMatching()) {
                SelectionRangeHandler.Direction direction = this.getDirection();
                SelectionRangeHandler handler = SelectionRangeHandler.getSelectionRangeHandler(styledText);
                if (handler.isDirty()) {
                    this.collectSelectionRanges(document, textSelection.getOffset()).thenApply(result -> {
                        if (result.isPresent()) {
                            List ranges = (List)result.get();
                            SelectionRange root = (SelectionRange)ranges.get(0);
                            handler.setRoot(root);
                            handler.updateSelection(provider, document, direction);
                        }
                        return null;
                    });
                } else {
                    handler.updateSelection(provider, document, direction);
                }
            }
        }
    }

    private CompletableFuture<Optional<List<SelectionRange>>> collectSelectionRanges(IDocument document, int offset) {
        if (document == null) {
            return CompletableFuture.completedFuture(null);
        }
        try {
            Position position = LSPEclipseUtils.toPosition(offset, document);
            TextDocumentIdentifier identifier = LSPEclipseUtils.toTextDocumentIdentifier(document);
            List<Position> positions = Collections.singletonList(position);
            SelectionRangeParams params = new SelectionRangeParams(identifier, positions);
            return ((LanguageServers.LanguageServerDocumentExecutor)LanguageServers.forDocument(document).withCapability(ServerCapabilities::getSelectionRangeProvider)).computeFirst(languageServer -> languageServer.getTextDocumentService().selectionRange(params)).thenApply(ranges -> ranges.stream().filter(Objects::nonNull).findFirst());
        }
        catch (BadLocationException e) {
            LanguageServerPlugin.logError(e);
            return CompletableFuture.completedFuture(null);
        }
    }

    public void setEnabled(Object evaluationContext) {
        this.setEnabled(ServerCapabilities::getSelectionRangeProvider, (ITextEditor x) -> true);
    }

    protected abstract SelectionRangeHandler.Direction getDirection();

    protected static class SelectionRangeHandler {
        private static final String KEY = SelectionRangeHandler.class.getName();
        private SelectionRange root;
        private SelectionRange previous;
        private final StyledText styledText;
        private boolean updating;

        public void setRoot(SelectionRange root) {
            this.root = root;
            this.previous = root;
        }

        public static SelectionRangeHandler getSelectionRangeHandler(StyledText styledText) {
            SelectionRangeHandler handler = (SelectionRangeHandler)styledText.getData(KEY);
            if (handler == null) {
                handler = new SelectionRangeHandler(styledText);
            }
            return handler;
        }

        public SelectionRangeHandler(StyledText styledText) {
            this.styledText = styledText;
            styledText.setData(KEY, (Object)this);
            styledText.addCaretListener(new CaretListener(){

                public void caretMoved(CaretEvent arg0) {
                    if (!updating) {
                        root = null;
                    }
                }
            });
        }

        public SelectionRange getSelectionRange(Direction direction) {
            if (direction == Direction.UP) {
                if (this.previous != null) {
                    this.previous = this.previous.getParent();
                    return this.previous;
                }
            } else if (this.previous != null) {
                SelectionRange selectionRange = this.root;
                while (selectionRange != null) {
                    SelectionRange parent = selectionRange.getParent();
                    if (this.previous.equals((Object)parent)) {
                        this.previous = selectionRange;
                        return this.previous;
                    }
                    selectionRange = parent;
                }
            }
            return null;
        }

        public boolean isDirty() {
            return this.root == null;
        }

        public void updateSelection(ISelectionProvider provider, IDocument document, Direction direction) {
            if (this.styledText.isDisposed()) {
                return;
            }
            SelectionRange selectionRange = this.getSelectionRange(direction);
            if (selectionRange != null) {
                ISelection selection = LSPEclipseUtils.toSelection(selectionRange.getRange(), document);
                this.styledText.getDisplay().execute(() -> {
                    try {
                        this.updating = true;
                        provider.setSelection(selection);
                    }
                    finally {
                        this.updating = false;
                    }
                });
            }
        }

        public static enum Direction {
            UP,
            DOWN;

        }
    }
}

