/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.symbols;

import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4e.operations.symbols.LSPSymbolInWorkspaceDialog;
import org.eclipse.lsp4e.ui.UI;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.texteditor.ITextEditor;

public class LSPSymbolInWorkspaceHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IEditorPart part = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        IResource resource = null;
        if (part != null && part.getEditorInput() != null) {
            resource = (IResource)part.getEditorInput().getAdapter(IResource.class);
        } else {
            IStructuredSelection selection = HandlerUtil.getCurrentStructuredSelection((ExecutionEvent)event);
            if (selection.isEmpty() || !(selection.getFirstElement() instanceof IAdaptable)) {
                return null;
            }
            IAdaptable adaptable = (IAdaptable)selection.getFirstElement();
            resource = (IResource)adaptable.getAdapter(IResource.class);
        }
        IProject project = resource.getProject();
        List<@NonNull LanguageServer> languageServers = LanguageServiceAccessor.getLanguageServers(project, capabilities -> LSPEclipseUtils.hasCapability((Either<Boolean, ? extends Object>)capabilities.getWorkspaceSymbolProvider()));
        if (languageServers.isEmpty()) {
            return null;
        }
        IWorkbenchSite site = HandlerUtil.getActiveSite((ExecutionEvent)event);
        if (site == null) {
            return null;
        }
        LSPSymbolInWorkspaceDialog dialog = new LSPSymbolInWorkspaceDialog(site.getShell(), languageServers);
        if (dialog.open() != 0) {
            return null;
        }
        SymbolInformation symbolInformation = (SymbolInformation)dialog.getFirstResult();
        Location location = symbolInformation.getLocation();
        LSPEclipseUtils.openInEditor(location, UI.getActivePage());
        return null;
    }

    public boolean isEnabled() {
        IWorkbenchPart part = UI.getActivePart();
        if (part instanceof ITextEditor) {
            List<LanguageServiceAccessor.LSPDocumentInfo> infos = LanguageServiceAccessor.getLSPDocumentInfosFor(LSPEclipseUtils.getDocument((ITextEditor)part), capabilities -> LSPEclipseUtils.hasCapability((Either<Boolean, ? extends Object>)capabilities.getWorkspaceSymbolProvider()));
            return !infos.isEmpty();
        }
        return false;
    }
}

