/**
 * Copyright (c) 2021 Contributors to the Eclipse Foundation
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Do not edit: This file is generated by Xtext
 */
package org.eclipse.lsat.dispatching.teditor.serializer;

import activity.ActivityPackage;
import activity.JitBounds;
import activity.TimeBounds;
import com.google.inject.Inject;
import common.CommonPackage;
import common.Import;
import common.ParameterReference;
import dispatching.ActivityDispatching;
import dispatching.Attribute;
import dispatching.Constraint;
import dispatching.Dispatch;
import dispatching.DispatchGroup;
import dispatching.DispatchingPackage;
import dispatching.Repeat;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.lsat.dispatching.teditor.services.DispatchingGrammarAccess;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Parameter;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.serializer.ISerializationContext;
import org.eclipse.xtext.serializer.acceptor.SequenceFeeder;
import org.eclipse.xtext.serializer.sequencer.AbstractDelegatingSemanticSequencer;
import org.eclipse.xtext.serializer.sequencer.ITransientValueService.ValueTransient;

@SuppressWarnings("all")
public abstract class AbstractDispatchingSemanticSequencer extends AbstractDelegatingSemanticSequencer {

    @Inject
    private DispatchingGrammarAccess grammarAccess;

    @Override
    public void sequence(ISerializationContext context, EObject semanticObject) {
        EPackage epackage = semanticObject.eClass().getEPackage();
        ParserRule rule = context.getParserRule();
        Action action = context.getAssignedAction();
        Set<Parameter> parameters = context.getEnabledBooleanParameters();
        if (epackage == ActivityPackage.eINSTANCE)
            switch (semanticObject.eClass().getClassifierID()) {
            case ActivityPackage.JIT_BOUNDS:
                sequence_JitBounds(context, (JitBounds) semanticObject); 
                return; 
            case ActivityPackage.TIME_BOUNDS:
                if (rule == grammarAccess.getInfTimeBoundsRule()) {
                    sequence_InfTimeBounds(context, (TimeBounds) semanticObject); 
                    return; 
                }
                else if (rule == grammarAccess.getTimeBoundsRule()) {
                    sequence_TimeBounds(context, (TimeBounds) semanticObject); 
                    return; 
                }
                else break;
            }
        else if (epackage == CommonPackage.eINSTANCE)
            switch (semanticObject.eClass().getClassifierID()) {
            case CommonPackage.IMPORT:
                sequence_Import(context, (Import) semanticObject); 
                return; 
            case CommonPackage.PARAMETER:
                sequence_Parameter(context, (common.Parameter) semanticObject); 
                return; 
            case CommonPackage.PARAMETER_REFERENCE:
                if (rule == grammarAccess.getFirstParameterReferenceRule()) {
                    sequence_FirstParameterReference(context, (ParameterReference) semanticObject); 
                    return; 
                }
                else if (rule == grammarAccess.getParameterReferenceRule()) {
                    sequence_ParameterReference(context, (ParameterReference) semanticObject); 
                    return; 
                }
                else break;
            }
        else if (epackage == DispatchingPackage.eINSTANCE)
            switch (semanticObject.eClass().getClassifierID()) {
            case DispatchingPackage.ACTIVITY_DISPATCHING:
                sequence_ActivityDispatching(context, (ActivityDispatching) semanticObject); 
                return; 
            case DispatchingPackage.ATTRIBUTE:
                sequence_Attribute(context, (Attribute) semanticObject); 
                return; 
            case DispatchingPackage.ATTRIBUTES_MAP_ENTRY:
                sequence_AttributesMapEntry(context, (Map.Entry & EObject) semanticObject); 
                return; 
            case DispatchingPackage.CONSTRAINT:
                if (rule == grammarAccess.getConstraintNestedRule()) {
                    sequence_Bounds_ConstraintNested_SourceAction_TargetAction(context, (Constraint) semanticObject); 
                    return; 
                }
                else if (rule == grammarAccess.getConstraintRule()) {
                    sequence_Bounds_Constraint_SourceAction_TargetAction(context, (Constraint) semanticObject); 
                    return; 
                }
                else break;
            case DispatchingPackage.DISPATCH:
                sequence_Dispatch(context, (Dispatch) semanticObject); 
                return; 
            case DispatchingPackage.DISPATCH_GROUP:
                sequence_DispatchGroup(context, (DispatchGroup) semanticObject); 
                return; 
            case DispatchingPackage.REPEAT:
                if (rule == grammarAccess.getNumberRepeatsRule()) {
                    sequence_NumberRepeats(context, (Repeat) semanticObject); 
                    return; 
                }
                else if (rule == grammarAccess.getRangeRule()) {
                    sequence_Range(context, (Repeat) semanticObject); 
                    return; 
                }
                else break;
            case DispatchingPackage.RESOURCE_ITERATIONS_MAP_ENTRY:
                sequence_ResourceIterationsMapEntry(context, (Map.Entry & EObject) semanticObject); 
                return; 
            case DispatchingPackage.RESOURCE_YIELD_MAP_ENTRY:
                sequence_ResourceYieldMapEntry(context, (Map.Entry & EObject) semanticObject); 
                return; 
            }
        if (errorAcceptor != null)
            errorAcceptor.accept(diagnosticProvider.createInvalidContextOrTypeDiagnostic(semanticObject, context));
    }

    /**
     * <pre>
     * Contexts:
     *     ActivityDispatching returns ActivityDispatching
     *
     * Constraint:
     *     (imports+=Import* numberOfIterations=INT? resourceIterations+=ResourceIterationsMapEntry* dispatchGroups+=DispatchGroup* constraints+=Constraint*)
     * </pre>
     */
                protected void sequence_ActivityDispatching(ISerializationContext context, ActivityDispatching semanticObject) {
    genericSequencer.createSequence(context, semanticObject);
    }
    

    /**
     * <pre>
     * Contexts:
     *     Attribute returns Attribute
     *
     * Constraint:
     *     name=ID
     * </pre>
     */
                protected void sequence_Attribute(ISerializationContext context, Attribute semanticObject) {
    if (errorAcceptor != null) {
        if (transientValues.isValueTransient(semanticObject, DispatchingPackage.Literals.ATTRIBUTE__NAME) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, DispatchingPackage.Literals.ATTRIBUTE__NAME));
    }
    SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
    feeder.accept(grammarAccess.getAttributeAccess().getNameIDTerminalRuleCall_1_0(), semanticObject.getName());
    feeder.finish();
    }
    

    /**
     * <pre>
     * Contexts:
     *     AttributesMapEntry returns AttributesMapEntry
     *
     * Constraint:
     *     (key=Attribute (value=IDString | value=INTASString))
     * </pre>
     */
                protected <T extends Map.Entry & EObject> void sequence_AttributesMapEntry(ISerializationContext context, T semanticObject) {
    genericSequencer.createSequence(context, (EObject) semanticObject);
    }
    

    /**
     * <pre>
     * Contexts:
     *     ConstraintNested returns Constraint
     *
     * Constraint:
     *     (
     *         sourceDispatch=[Dispatch|IID] 
     *         sourceAction=[Action|IID] 
     *         (bounds=JitBounds | bounds=TimeBounds | bounds=InfTimeBounds) 
     *         targetDispatch=[Dispatch|IID] 
     *         targetAction=[Action|IID]
     *     )
     * </pre>
     */
                protected void sequence_Bounds_ConstraintNested_SourceAction_TargetAction(ISerializationContext context, Constraint semanticObject) {
    genericSequencer.createSequence(context, semanticObject);
    }
    

    /**
     * <pre>
     * Contexts:
     *     Constraint returns Constraint
     *
     * Constraint:
     *     (
     *         sourceDispatchGroup=[DispatchGroup|IID] 
     *         sourceDispatch=[Dispatch|IID] 
     *         sourceAction=[Action|IID] 
     *         (bounds=JitBounds | bounds=TimeBounds | bounds=InfTimeBounds) 
     *         targetDispatchGroup=[DispatchGroup|IID] 
     *         targetDispatch=[Dispatch|IID] 
     *         targetAction=[Action|IID]
     *     )
     * </pre>
     */
                protected void sequence_Bounds_Constraint_SourceAction_TargetAction(ISerializationContext context, Constraint semanticObject) {
    genericSequencer.createSequence(context, semanticObject);
    }
    

    /**
     * <pre>
     * Contexts:
     *     DispatchGroup returns DispatchGroup
     *
     * Constraint:
     *     (
     *         name=IDString? 
     *         (userAttributes+=AttributesMapEntry userAttributes+=AttributesMapEntry*)? 
     *         (iteratorName=IDString? (repeats+=NumberRepeats | (repeats+=Range repeats+=Range*)))? 
     *         yield=INT? 
     *         resourceYield+=ResourceYieldMapEntry* 
     *         offset=EBigDecimal? 
     *         dispatches+=Dispatch* 
     *         constraints+=ConstraintNested*
     *     )
     * </pre>
     */
                protected void sequence_DispatchGroup(ISerializationContext context, DispatchGroup semanticObject) {
    genericSequencer.createSequence(context, semanticObject);
    }
    

    /**
     * <pre>
     * Contexts:
     *     Dispatch returns Dispatch
     *
     * Constraint:
     *     (
     *         name=IID? 
     *         activity=[Activity|ID] 
     *         (parameters+=Parameter parameters+=Parameter*)? 
     *         description=STRING? 
     *         (userAttributes+=AttributesMapEntry userAttributes+=AttributesMapEntry*)?
     *     )
     * </pre>
     */
                protected void sequence_Dispatch(ISerializationContext context, Dispatch semanticObject) {
    genericSequencer.createSequence(context, semanticObject);
    }
    

    /**
     * <pre>
     * Contexts:
     *     FirstParameterReference returns ParameterReference
     *
     * Constraint:
     *     reference=[TypeDefinition|ID]
     * </pre>
     */
                protected void sequence_FirstParameterReference(ISerializationContext context, ParameterReference semanticObject) {
    if (errorAcceptor != null) {
        if (transientValues.isValueTransient(semanticObject, CommonPackage.Literals.PARAMETER_REFERENCE__REFERENCE) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, CommonPackage.Literals.PARAMETER_REFERENCE__REFERENCE));
    }
    SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
    feeder.accept(grammarAccess.getFirstParameterReferenceAccess().getReferenceTypeDefinitionIDTerminalRuleCall_1_0_1(), semanticObject.eGet(CommonPackage.Literals.PARAMETER_REFERENCE__REFERENCE, false));
    feeder.finish();
    }
    

    /**
     * <pre>
     * Contexts:
     *     Import returns Import
     *
     * Constraint:
     *     importURI=STRING
     * </pre>
     */
                protected void sequence_Import(ISerializationContext context, Import semanticObject) {
    if (errorAcceptor != null) {
        if (transientValues.isValueTransient(semanticObject, CommonPackage.Literals.IMPORT__IMPORT_URI) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, CommonPackage.Literals.IMPORT__IMPORT_URI));
    }
    SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
    feeder.accept(grammarAccess.getImportAccess().getImportURISTRINGTerminalRuleCall_2_0(), semanticObject.getImportURI());
    feeder.finish();
    }
    

    /**
     * <pre>
     * Contexts:
     *     InfTimeBounds returns TimeBounds
     *
     * Constraint:
     *     {TimeBounds}
     * </pre>
     */
                protected void sequence_InfTimeBounds(ISerializationContext context, TimeBounds semanticObject) {
    genericSequencer.createSequence(context, semanticObject);
    }
    

    /**
     * <pre>
     * Contexts:
     *     JitBounds returns JitBounds
     *
     * Constraint:
     *     {JitBounds}
     * </pre>
     */
                protected void sequence_JitBounds(ISerializationContext context, JitBounds semanticObject) {
    genericSequencer.createSequence(context, semanticObject);
    }
    

    /**
     * <pre>
     * Contexts:
     *     NumberRepeats returns Repeat
     *
     * Constraint:
     *     numRepeats=INT
     * </pre>
     */
                protected void sequence_NumberRepeats(ISerializationContext context, Repeat semanticObject) {
    if (errorAcceptor != null) {
        if (transientValues.isValueTransient(semanticObject, DispatchingPackage.Literals.REPEAT__NUM_REPEATS) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, DispatchingPackage.Literals.REPEAT__NUM_REPEATS));
    }
    SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
    feeder.accept(grammarAccess.getNumberRepeatsAccess().getNumRepeatsINTTerminalRuleCall_1_0(), semanticObject.getNumRepeats());
    feeder.finish();
    }
    

    /**
     * <pre>
     * Contexts:
     *     ParameterReference returns ParameterReference
     *
     * Constraint:
     *     reference=[TypeDefinition|IID]
     * </pre>
     */
                protected void sequence_ParameterReference(ISerializationContext context, ParameterReference semanticObject) {
    if (errorAcceptor != null) {
        if (transientValues.isValueTransient(semanticObject, CommonPackage.Literals.PARAMETER_REFERENCE__REFERENCE) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, CommonPackage.Literals.PARAMETER_REFERENCE__REFERENCE));
    }
    SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
    feeder.accept(grammarAccess.getParameterReferenceAccess().getReferenceTypeDefinitionIIDParserRuleCall_1_0_1(), semanticObject.eGet(CommonPackage.Literals.PARAMETER_REFERENCE__REFERENCE, false));
    feeder.finish();
    }
    

    /**
     * <pre>
     * Contexts:
     *     Parameter returns Parameter
     *
     * Constraint:
     *     (declaration=[TypeDefinition|ID]? references+=FirstParameterReference references+=ParameterReference*)
     * </pre>
     */
                protected void sequence_Parameter(ISerializationContext context, common.Parameter semanticObject) {
    genericSequencer.createSequence(context, semanticObject);
    }
    

    /**
     * <pre>
     * Contexts:
     *     Range returns Repeat
     *
     * Constraint:
     *     (start=INT | (start=INT end=INT))
     * </pre>
     */
                protected void sequence_Range(ISerializationContext context, Repeat semanticObject) {
    genericSequencer.createSequence(context, semanticObject);
    }
    

    /**
     * <pre>
     * Contexts:
     *     ResourceIterationsMapEntry returns ResourceIterationsMapEntry
     *
     * Constraint:
     *     (key=[IResource|ResourceQualifiedName] value=INT)
     * </pre>
     */
                protected <T extends Map.Entry & EObject> void sequence_ResourceIterationsMapEntry(ISerializationContext context, T semanticObject) {
    if (errorAcceptor != null) {
        if (transientValues.isValueTransient((EObject) semanticObject, DispatchingPackage.Literals.RESOURCE_ITERATIONS_MAP_ENTRY__KEY) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing((EObject) semanticObject, DispatchingPackage.Literals.RESOURCE_ITERATIONS_MAP_ENTRY__KEY));
        if (transientValues.isValueTransient((EObject) semanticObject, DispatchingPackage.Literals.RESOURCE_ITERATIONS_MAP_ENTRY__VALUE) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing((EObject) semanticObject, DispatchingPackage.Literals.RESOURCE_ITERATIONS_MAP_ENTRY__VALUE));
    }
    SequenceFeeder feeder = createSequencerFeeder(context, (EObject) semanticObject);
    feeder.accept(grammarAccess.getResourceIterationsMapEntryAccess().getKeyIResourceResourceQualifiedNameParserRuleCall_2_0_1(), semanticObject.eGet(DispatchingPackage.Literals.RESOURCE_ITERATIONS_MAP_ENTRY__KEY, false));
    feeder.accept(grammarAccess.getResourceIterationsMapEntryAccess().getValueINTTerminalRuleCall_4_0(), semanticObject.getValue());
    feeder.finish();
    }
    

    /**
     * <pre>
     * Contexts:
     *     ResourceYieldMapEntry returns ResourceYieldMapEntry
     *
     * Constraint:
     *     (key=[IResource|ResourceQualifiedName] value=INT)
     * </pre>
     */
                protected <T extends Map.Entry & EObject> void sequence_ResourceYieldMapEntry(ISerializationContext context, T semanticObject) {
    if (errorAcceptor != null) {
        if (transientValues.isValueTransient((EObject) semanticObject, DispatchingPackage.Literals.RESOURCE_YIELD_MAP_ENTRY__KEY) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing((EObject) semanticObject, DispatchingPackage.Literals.RESOURCE_YIELD_MAP_ENTRY__KEY));
        if (transientValues.isValueTransient((EObject) semanticObject, DispatchingPackage.Literals.RESOURCE_YIELD_MAP_ENTRY__VALUE) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing((EObject) semanticObject, DispatchingPackage.Literals.RESOURCE_YIELD_MAP_ENTRY__VALUE));
    }
    SequenceFeeder feeder = createSequencerFeeder(context, (EObject) semanticObject);
    feeder.accept(grammarAccess.getResourceYieldMapEntryAccess().getKeyIResourceResourceQualifiedNameParserRuleCall_1_0_1(), semanticObject.eGet(DispatchingPackage.Literals.RESOURCE_YIELD_MAP_ENTRY__KEY, false));
    feeder.accept(grammarAccess.getResourceYieldMapEntryAccess().getValueINTTerminalRuleCall_3_0(), semanticObject.getValue());
    feeder.finish();
    }
    

    /**
     * <pre>
     * Contexts:
     *     TimeBounds returns TimeBounds
     *
     * Constraint:
     *     (lower=EBigDecimal upper=EBigDecimal)
     * </pre>
     */
                protected void sequence_TimeBounds(ISerializationContext context, TimeBounds semanticObject) {
    if (errorAcceptor != null) {
        if (transientValues.isValueTransient(semanticObject, ActivityPackage.Literals.TIME_BOUNDS__LOWER) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, ActivityPackage.Literals.TIME_BOUNDS__LOWER));
        if (transientValues.isValueTransient(semanticObject, ActivityPackage.Literals.TIME_BOUNDS__UPPER) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, ActivityPackage.Literals.TIME_BOUNDS__UPPER));
    }
    SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
    feeder.accept(grammarAccess.getTimeBoundsAccess().getLowerEBigDecimalParserRuleCall_2_0(), semanticObject.getLower());
    feeder.accept(grammarAccess.getTimeBoundsAccess().getUpperEBigDecimalParserRuleCall_4_0(), semanticObject.getUpper());
    feeder.finish();
    }
    

}
